/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff.core;

import com.qarks.util.Cancellable;
import com.qarks.util.files.diff.DirContentStatus;
import com.qarks.util.files.diff.DirDiffResult;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FolderComparator {
    private static boolean containsOneDiff(List<DirContentStatus> list) {
        boolean bl = false;
        for (int i = 0; !bl && i < list.size(); ++i) {
            DirContentStatus dirContentStatus = list.get(i);
            if (dirContentStatus.getStatus() != DirContentStatus.Status.NEW && dirContentStatus.getStatus() != DirContentStatus.Status.MODIFIED) continue;
            bl = true;
        }
        return bl;
    }

    public static DirDiffResult compareFolders(File file, File file2, Cancellable cancellable) throws IOException {
        DirContentStatus dirContentStatus;
        File file3;
        Object object;
        Object object2;
        Object object3;
        DirDiffResult dirDiffResult = new DirDiffResult(file, file2);
        if (!file.exists()) {
            throw new IOException("left folder does not exist");
        }
        if (!file2.exists()) {
            throw new IOException("right folder does not exist");
        }
        if (!file.isDirectory()) {
            throw new IOException("left file is not a folder");
        }
        if (!file2.isDirectory()) {
            throw new IOException("right file is not a folder");
        }
        HashMap<String, File> hashMap = FolderComparator.buildMap(file);
        HashMap<String, File> hashMap2 = FolderComparator.buildMap(file2);
        Iterator<Map.Entry<String, File>> iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext() && !cancellable.isCancelled()) {
            object3 = iterator.next();
            object2 = (String)object3.getKey();
            object = (File)object3.getValue();
            file3 = hashMap2.get(object2);
            if (file3 == null) {
                DirContentStatus dirContentStatus2 = dirDiffResult.getLeftContent().addFileNew((File)object);
                if (!((File)object).isDirectory()) continue;
                FolderComparator.fillNewFolder(dirContentStatus2);
                continue;
            }
            if (((File)object).isDirectory() != file3.isDirectory()) {
                DirContentStatus dirContentStatus3 = dirDiffResult.getLeftContent().addFileNew((File)object);
                if (((File)object).isDirectory()) {
                    FolderComparator.fillNewFolder(dirContentStatus3);
                }
                dirContentStatus = dirDiffResult.getRightContent().addFileNew(file3);
                if (!file3.isDirectory()) continue;
                FolderComparator.fillNewFolder(dirContentStatus);
                continue;
            }
            if (((File)object).isDirectory()) {
                DirDiffResult dirDiffResult2 = FolderComparator.compareFolders((File)object, file3, cancellable);
                dirContentStatus = dirDiffResult.getLeftContent().addFileEqual((File)object);
                DirContentStatus dirContentStatus4 = dirDiffResult.getRightContent().addFileEqual(file3);
                if (FolderComparator.containsOneDiff(dirDiffResult2.getLeftContent().getChildren()) || FolderComparator.containsOneDiff(dirDiffResult2.getRightContent().getChildren())) {
                    dirContentStatus.setStatus(DirContentStatus.Status.MODIFIED);
                    dirContentStatus4.setStatus(DirContentStatus.Status.MODIFIED);
                }
                dirContentStatus.addAll(dirDiffResult2.getLeftContent());
                dirContentStatus4.addAll(dirDiffResult2.getRightContent());
                continue;
            }
            boolean bl = FolderComparator.areFileEqual((File)object, file3, cancellable);
            if (bl) {
                dirDiffResult.getLeftContent().addFileEqual((File)object);
                dirDiffResult.getRightContent().addFileEqual(file3);
                continue;
            }
            dirDiffResult.getLeftContent().addFileModified((File)object, file3);
            dirDiffResult.getRightContent().addFileModified(file3, (File)object);
        }
        object3 = hashMap2.entrySet().iterator();
        while (object3.hasNext() && !cancellable.isCancelled()) {
            object2 = (Map.Entry)object3.next();
            object = (String)object2.getKey();
            file3 = (File)object2.getValue();
            File file4 = hashMap.get(object);
            if (file4 != null) continue;
            dirContentStatus = dirDiffResult.getRightContent().addFileNew(file3);
            if (!file3.isDirectory()) continue;
            FolderComparator.fillNewFolder(dirContentStatus);
        }
        return dirDiffResult;
    }

    private static void fillNewFolder(DirContentStatus dirContentStatus) {
        File[] fileArray;
        for (File file : fileArray = dirContentStatus.getFile().listFiles()) {
            DirContentStatus dirContentStatus2 = dirContentStatus.addFileNew(file);
            if (!file.isDirectory()) continue;
            FolderComparator.fillNewFolder(dirContentStatus2);
        }
    }

    private static HashMap<String, File> buildMap(File file) {
        HashMap<String, File> hashMap = new HashMap<String, File>();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                hashMap.put(file2.getName(), file2);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean areFileEqual(File file, File file2, Cancellable cancellable) throws IOException {
        boolean bl = true;
        if (file.length() == file2.length()) {
            InputStream inputStream = null;
            InputStream inputStream2 = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file));
                inputStream2 = new BufferedInputStream(new FileInputStream(file2));
                int n = 0;
                int n2 = 0;
                while (bl && n > -1 && !cancellable.isCancelled()) {
                    n = inputStream.read();
                    if (n == (n2 = inputStream2.read())) continue;
                    bl = false;
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        bl = false;
        return bl;
    }
}

