/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.exportchooser.AbstractExportFileType;
import org.freehep.graphicsio.exportchooser.BackgroundPanel;
import org.freehep.graphicsio.exportchooser.FontPanel;
import org.freehep.graphicsio.exportchooser.ImageTypePanel;
import org.freehep.graphicsio.exportchooser.InfoPanel;
import org.freehep.graphicsio.exportchooser.OptionCheckBox;
import org.freehep.graphicsio.exportchooser.OptionComboBox;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.graphicsio.exportchooser.PageLayoutPanel;
import org.freehep.graphicsio.exportchooser.PageMarginPanel;
import org.freehep.graphicsio.pdf.PDFGraphics2D;

public class PDFExportFileType
extends AbstractExportFileType {
    private static final String[] versionList = new String[]{"Acrobat Reader 4.x", "Acrobat Reader 5.x"};

    public String getDescription() {
        return "Portable Document Format";
    }

    public String[] getExtensions() {
        return new String[]{"pdf"};
    }

    public String[] getMIMETypes() {
        return new String[]{"application/pdf"};
    }

    public boolean isMultipageCapable() {
        return true;
    }

    public boolean hasOptionPanel() {
        return true;
    }

    public JPanel createOptionPanel(Properties user) {
        UserProperties options = new UserProperties(user, PDFGraphics2D.getDefaultProperties());
        OptionPanel format = new OptionPanel("Format");
        OptionComboBox version = new OptionComboBox((Properties)options, PDFGraphics2D.VERSION, versionList);
        format.add("0 * [5 15 5 15] r", (Component)new JLabel("PDF Version"));
        format.add("1 * [5 15 5 15] lw", (Component)version);
        format.add("0 * * 1 [5 15 5 15] w", (Component)new OptionCheckBox((Properties)options, PDFGraphics2D.COMPRESS, "Compress"));
        OptionPanel preview = new OptionPanel("Preview");
        OptionCheckBox thumbnails = new OptionCheckBox((Properties)options, PDFGraphics2D.THUMBNAILS, "Include Thumbnail");
        thumbnails.setToolTipText("Thumbnails are automatically generated by Acrobat Reader 5");
        preview.add("0 * * 1 [5 15 5 15] w", (Component)thumbnails);
        version.selects("Acrobat Reader 4.x", (AbstractButton)thumbnails);
        String rootKey = PDFGraphics2D.class.getName();
        String abstractRootKey = AbstractVectorGraphicsIO.class.getName();
        InfoPanel infoPanel = new InfoPanel((Properties)options, rootKey, new String[]{"Author", "Title", "Subject", "Keywords"});
        OptionPanel leftPanel = new OptionPanel();
        leftPanel.add("0 * wt", (Component)new PageLayoutPanel((Properties)options, rootKey));
        leftPanel.add("0 * wt", (Component)new PageMarginPanel((Properties)options, rootKey));
        leftPanel.add("0 * wh", new JLabel());
        OptionPanel rightPanel = new OptionPanel();
        rightPanel.add("0 * wt", (Component)format);
        rightPanel.add("0 * wt", (Component)preview);
        rightPanel.add("0 * wt", (Component)new BackgroundPanel((Properties)options, rootKey, true));
        rightPanel.add("0 * wt", (Component)new ImageTypePanel((Properties)options, rootKey, new String[]{"Smallest Size", "ZLIB", "JPG"}));
        rightPanel.add("0 * wt", (Component)new FontPanel((Properties)options, rootKey, abstractRootKey));
        rightPanel.add("0 * wh", new JLabel());
        OptionPanel optionsPanel = new OptionPanel();
        optionsPanel.add("0 0 [5 5 5 5] wt", (Component)leftPanel);
        optionsPanel.add("1 0 [5 5 5 5] wt", (Component)rightPanel);
        optionsPanel.add("0 1 2 1 [5 5 5 5] wt", (Component)infoPanel);
        optionsPanel.add("0 * wh", (Component)new JLabel());
        return optionsPanel;
    }

    public VectorGraphics getGraphics(OutputStream os, Component target) throws IOException {
        return new PDFGraphics2D(os, target);
    }

    public VectorGraphics getGraphics(OutputStream os, Dimension dimension) throws IOException {
        return new PDFGraphics2D(os, dimension);
    }
}

