/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import vcf.Marker;
import vcf.VcfEmission;
import vcf.VcfHeader;
import vcf.VcfRecGTParser;

public final class ByteArrayRefGT
implements VcfEmission {
    private final Marker marker;
    private final Samples samples;
    private final byte[] allele1;
    private final byte[] allele2;

    public ByteArrayRefGT(VcfHeader vcfHeader, String string) {
        this(new VcfRecGTParser(vcfHeader, string));
    }

    public ByteArrayRefGT(VcfRecGTParser vcfRecGTParser) {
        if (vcfRecGTParser.marker().nAlleles() > 127) {
            throw new IllegalArgumentException(vcfRecGTParser.marker().toString());
        }
        if (vcfRecGTParser.currentSample() > 0) {
            throw new IllegalArgumentException(String.valueOf(vcfRecGTParser.currentSample()));
        }
        this.marker = vcfRecGTParser.marker();
        this.samples = vcfRecGTParser.samples();
        this.allele1 = new byte[vcfRecGTParser.nSamples()];
        this.allele2 = new byte[vcfRecGTParser.nSamples()];
        ByteArrayRefGT.storeAlleles(vcfRecGTParser, this.allele1, this.allele2);
    }

    private static void storeAlleles(VcfRecGTParser vcfRecGTParser, byte[] byArray, byte[] byArray2) {
        int n = vcfRecGTParser.nSamples();
        for (int i = 0; i < n; ++i) {
            byte by = (byte)vcfRecGTParser.allele1();
            byte by2 = (byte)vcfRecGTParser.allele2();
            if (!vcfRecGTParser.isPhased() || by == -1 || by2 == -2) {
                String string = "Unphased or missing reference genotype at marker: " + vcfRecGTParser.marker();
                throw new IllegalArgumentException(string);
            }
            byArray[i] = by;
            byArray2[i] = by2;
            if (i + 1 >= n) continue;
            vcfRecGTParser.nextSample();
        }
    }

    @Override
    public boolean isPhased(int n) {
        if (n < 0 || n >= this.nSamples()) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        return true;
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public int nHaps() {
        return 2 * this.samples.nSamples();
    }

    @Override
    public int nHapPairs() {
        return this.samples.nSamples();
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public boolean isRefData() {
        return true;
    }

    @Override
    public float gl(int n, int n2, int n3) {
        if (n2 < 0 || n2 >= this.marker.nAlleles()) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        if (n3 < 0 || n3 >= this.marker.nAlleles()) {
            throw new IndexOutOfBoundsException(String.valueOf(n3));
        }
        boolean bl = n2 == this.allele1(n) && n3 == this.allele2(n);
        return bl ? 1.0f : 0.0f;
    }

    @Override
    public int allele1(int n) {
        return this.allele1[n];
    }

    @Override
    public int allele2(int n) {
        return this.allele2[n];
    }

    @Override
    public int allele(int n) {
        int n2 = n / 2;
        return (n & 1) == 0 ? this.allele1(n2) : this.allele2(n2);
    }

    @Override
    public int nAlleles() {
        return this.marker().nAlleles();
    }

    @Override
    public boolean storesNonMajorIndices() {
        return false;
    }

    @Override
    public int majorAllele() {
        String string = "this.storesNonMajorIndices()==false";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public int alleleCount(int n) {
        String string = "this.storesNonMajorIndices()==false";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public int hapIndex(int n, int n2) {
        String string = "this.storesNonMajorIndices()==false";
        throw new UnsupportedOperationException(string);
    }

    public String toString() {
        return this.toVcfRec();
    }
}

