/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.Samples;
import vcf.Marker;
import vcf.Markers;

public class SampleGenotypeValues {
    private final Markers markers;
    private final Samples samples;
    private final int sampleIndex;
    private final float[] gtValues;

    public SampleGenotypeValues(Markers markers, Samples samples, int n) {
        if (n < 0 || n >= samples.nSamples()) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.markers = markers;
        this.samples = samples;
        this.sampleIndex = n;
        this.gtValues = new float[markers.sumGenotypes()];
    }

    public synchronized float value(int n, int n2) {
        this.checkGenotype(n, n2);
        return this.gtValues[this.markers.sumGenotypes(n) + n2];
    }

    public synchronized void add(double[] dArray) {
        if (dArray.length != this.gtValues.length) {
            String string = "values.length=" + dArray.length;
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            this.gtValues[n] = (float)((double)this.gtValues[n] + dArray[i]);
        }
    }

    public synchronized void add(int n, int n2, double d) {
        this.checkGenotype(n, n2);
        int n3 = this.markers.sumGenotypes(n) + n2;
        this.gtValues[n3] = (float)((double)this.gtValues[n3] + d);
    }

    private void checkGenotype(int n, int n2) {
        int n3 = this.markers.marker(n).nGenotypes();
        if (n2 < 0 || n2 >= n3) {
            throw new IndexOutOfBoundsException("genotype: " + n2);
        }
    }

    public Markers markers() {
        return this.markers;
    }

    public Samples samples() {
        return this.samples;
    }

    public int sampleIndex() {
        return this.sampleIndex;
    }

    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    public int nMarkers() {
        return this.markers.nMarkers();
    }

    public String toString() {
        return this.getClass().toString();
    }
}

