/*
 * Decompiled with CFR 0.152.
 */
package haplotype;

import blbutil.FileIt;
import haplotype.HapPairs;
import java.io.File;
import java.util.NoSuchElementException;
import vcf.HapsMarker;
import vcf.Marker;

public class HapsMarkerIterator
implements FileIt<HapsMarker> {
    private final HapPairs haps;
    private int nextIndex = 0;

    public HapsMarkerIterator(HapPairs hapPairs) {
        if (hapPairs == null) {
            throw new NullPointerException("haps==nullt");
        }
        this.haps = hapPairs;
    }

    @Override
    public File file() {
        return null;
    }

    @Override
    public void close() {
        this.nextIndex = this.haps.nMarkers();
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex < this.haps.nMarkers();
    }

    @Override
    public HapsMarker next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("hasNext()==false");
        }
        final int n = this.nextIndex++;
        return new HapsMarker(){

            @Override
            public int allele(int n2) {
                return HapsMarkerIterator.this.haps.allele(n, n2);
            }

            @Override
            public int allele1(int n2) {
                return HapsMarkerIterator.this.haps.allele(n, 2 * n2);
            }

            @Override
            public int allele2(int n2) {
                return HapsMarkerIterator.this.haps.allele(n, 2 * n2 + 1);
            }

            @Override
            public Marker marker() {
                return HapsMarkerIterator.this.haps.marker(n);
            }

            @Override
            public int nHaps() {
                return HapsMarkerIterator.this.haps.nHaps();
            }

            @Override
            public int nHapPairs() {
                return HapsMarkerIterator.this.haps.nHapPairs();
            }
        };
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }
}

