/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.converter.transformations.AbstractTransformation;
import org.jpmml.xgboost.Classification;
import org.jpmml.xgboost.RegTree;

public class HingeClassification
extends Classification {
    public HingeClassification(String name) {
        super(name, 2);
    }

    @Override
    public MiningModel encodeModel(List<RegTree> trees, List<Float> weights, float base_score, Integer ntreeLimit, Schema schema) {
        Schema segmentSchema = schema.toAnonymousRegressorSchema(DataType.FLOAT);
        AbstractTransformation transformation = new AbstractTransformation(){

            public String getName(String name) {
                return FieldNameUtil.create((String)"hinge", (Object[])new Object[]{name});
            }

            public Expression createExpression(FieldRef fieldRef) {
                return ExpressionUtil.createApply((String)"threshold", (Expression[])new Expression[]{fieldRef, ExpressionUtil.createConstant((Number)Float.valueOf(0.0f))});
            }
        };
        MiningModel miningModel = HingeClassification.createMiningModel(trees, weights, base_score, ntreeLimit, segmentSchema).setOutput(ModelUtil.createPredictedOutput((String)"xgbValue", (OpType)OpType.CONTINUOUS, (DataType)DataType.FLOAT, (Transformation[])new Transformation[]{transformation}));
        return MiningModelUtil.createBinaryLogisticClassification((Model)miningModel, (double)1.0, (double)0.0, (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.NONE, (boolean)true, (Schema)schema);
    }
}

