/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.tree;

import org.dmg.pmml.tree.BranchNode;
import org.dmg.pmml.tree.ClassifierNode;
import org.dmg.pmml.tree.ComplexNode;
import org.dmg.pmml.tree.CountingBranchNode;
import org.dmg.pmml.tree.CountingLeafNode;
import org.dmg.pmml.tree.LeafNode;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.NodeTransformer;

public class SimplifyingNodeTransformer
implements NodeTransformer {
    public static final SimplifyingNodeTransformer INSTANCE = new SimplifyingNodeTransformer();

    @Override
    public Node fromComplexNode(ComplexNode complexNode) {
        return this.simplify(complexNode);
    }

    @Override
    public ComplexNode toComplexNode(Node node) {
        return node.toComplexNode();
    }

    public Node simplify(Node node) {
        if (node.hasExtensions() || node.getPartition() != null || node.getEmbeddedModel() != null) {
            return node;
        }
        if (node.hasScoreDistributions()) {
            return new ClassifierNode(node);
        }
        Number recordCount = node.getRecordCount();
        if (node.hasNodes()) {
            if (recordCount != null) {
                return new CountingBranchNode(node);
            }
            return new BranchNode(node);
        }
        if (recordCount != null) {
            return new CountingLeafNode(node);
        }
        return new LeafNode(node);
    }
}

