/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.general_regression;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.dmg.pmml.general_regression.BaselineCell;
import org.dmg.pmml.general_regression.PMMLAttributes;
import org.dmg.pmml.general_regression.PMMLElements;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="BaselineStratum", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "baselineCells"})
@JsonRootName(value="BaselineStratum")
@JsonPropertyOrder(value={"value", "label", "maxTime", "extensions", "baselineCells"})
@Added(value=Version.PMML_4_0)
public class BaselineStratum
extends PMMLObject
implements HasExtensions<BaselineStratum>,
HasValue<BaselineStratum> {
    @XmlAttribute(name="value", required=true)
    @XmlJavaTypeAdapter(value=ObjectAdapter.class)
    @XmlSchemaType(name="anySimpleType")
    @JsonProperty(value="value")
    private Object value;
    @XmlAttribute(name="label")
    @JsonProperty(value="label")
    private String label;
    @XmlAttribute(name="maxTime", required=true)
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="maxTime")
    private Number maxTime;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="BaselineCell", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="BaselineCell")
    private List<BaselineCell> baselineCells;
    private static final long serialVersionUID = 67371272L;

    public BaselineStratum() {
    }

    @ValueConstructor
    public BaselineStratum(@Property(value="value") Object value, @Property(value="maxTime") Number maxTime) {
        this.value = value;
        this.maxTime = maxTime;
    }

    @Override
    public Object requireValue() {
        if (this.value == null) {
            throw new MissingAttributeException(this, PMMLAttributes.BASELINESTRATUM_VALUE);
        }
        return this.value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public BaselineStratum setValue(@Property(value="value") Object value) {
        this.value = value;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public BaselineStratum setLabel(@Property(value="label") String label) {
        this.label = label;
        return this;
    }

    public Number requireMaxTime() {
        if (this.maxTime == null) {
            throw new MissingAttributeException(this, PMMLAttributes.BASELINESTRATUM_MAXTIME);
        }
        return this.maxTime;
    }

    public Number getMaxTime() {
        return this.maxTime;
    }

    public BaselineStratum setMaxTime(@Property(value="maxTime") Number maxTime) {
        this.maxTime = maxTime;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public BaselineStratum addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasBaselineCells() {
        return this.baselineCells != null && !this.baselineCells.isEmpty();
    }

    public List<BaselineCell> requireBaselineCells() {
        if (this.baselineCells == null || this.baselineCells.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.BASELINESTRATUM_BASELINECELLS);
        }
        return this.baselineCells;
    }

    public List<BaselineCell> getBaselineCells() {
        if (this.baselineCells == null) {
            this.baselineCells = new ArrayList<BaselineCell>();
        }
        return this.baselineCells;
    }

    public BaselineStratum addBaselineCells(BaselineCell ... baselineCells) {
        this.getBaselineCells().addAll(Arrays.asList(baselineCells));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasBaselineCells()) {
                status = PMMLObject.traverse(visitor, this.getBaselineCells());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

