/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jpmml.rexp.RDataInput;

public abstract class BinaryInput
implements RDataInput {
    private DataInputStream dis = null;
    private static final byte[] XDR2_MAGIC = new byte[]{88, 68, 82, 50, 10};

    public BinaryInput(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        byte first = dis.readByte();
        if (first != 88) {
            throw new IllegalArgumentException();
        }
        byte second = dis.readByte();
        if (second != 10) {
            byte[] xdrMagic = new byte[5];
            xdrMagic[0] = first;
            xdrMagic[1] = second;
            dis.readFully(xdrMagic, 2, xdrMagic.length - 2);
            if (!Arrays.equals(XDR2_MAGIC, xdrMagic)) {
                throw new IllegalArgumentException();
            }
        }
        this.dis = dis;
    }

    @Override
    public void close() throws IOException {
        this.dis.close();
    }

    @Override
    public int readInt() throws IOException {
        int value = this.dis.readInt();
        return value;
    }

    @Override
    public double readDouble() throws IOException {
        long value = this.dis.readLong();
        return Double.longBitsToDouble(value);
    }

    @Override
    public byte[] readByteArray(int length) throws IOException {
        byte[] buffer = new byte[length];
        this.dis.readFully(buffer);
        return buffer;
    }
}

