/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import java.util.concurrent.CopyOnWriteArraySet;
import moa.core.ObjectRepository;
import moa.core.TimingUtils;
import moa.tasks.FailedTaskReport;
import moa.tasks.ResultPreviewListener;
import moa.tasks.StandardTaskMonitor;
import moa.tasks.Task;
import moa.tasks.TaskCompletionListener;
import moa.tasks.TaskMonitor;

public class TaskThread
extends Thread {
    protected Task runningTask;
    protected volatile Status currentStatus;
    protected TaskMonitor taskMonitor;
    protected ObjectRepository repository;
    protected Object finalResult;
    protected long taskStartTime;
    protected long taskEndTime;
    protected double latestPreviewGrabTime = 0.0;
    CopyOnWriteArraySet<TaskCompletionListener> completionListeners = new CopyOnWriteArraySet();

    public TaskThread(Task toRun) {
        this(toRun, null);
    }

    public TaskThread(Task toRun, ObjectRepository repository) {
        this.runningTask = toRun;
        this.repository = repository;
        this.currentStatus = Status.NOT_STARTED;
        this.taskMonitor = new StandardTaskMonitor();
        this.taskMonitor.setCurrentActivityDescription("Running task " + toRun);
    }

    public void run() {
        TimingUtils.enablePreciseTiming();
        this.taskStartTime = TimingUtils.getNanoCPUTimeOfThread(this.getId());
        try {
            this.currentStatus = Status.RUNNING;
            this.finalResult = this.runningTask.doTask(this.taskMonitor, this.repository);
            this.currentStatus = this.taskMonitor.isCancelled() ? Status.CANCELLED : Status.COMPLETED;
        }
        catch (Throwable ex) {
            this.currentStatus = Status.FAILED;
            this.finalResult = new FailedTaskReport(ex);
        }
        this.taskEndTime = TimingUtils.getNanoCPUTimeOfThread(this.getId());
        this.fireTaskCompleted();
        this.taskMonitor.setLatestResultPreview(null);
    }

    public synchronized void pauseTask() {
        if (this.currentStatus == Status.RUNNING) {
            this.taskMonitor.requestPause();
            this.currentStatus = Status.PAUSED;
        }
    }

    public synchronized void resumeTask() {
        if (this.currentStatus == Status.PAUSED) {
            this.taskMonitor.requestResume();
            this.currentStatus = Status.RUNNING;
        }
    }

    public synchronized void cancelTask() {
        if (this.currentStatus == Status.RUNNING || this.currentStatus == Status.PAUSED) {
            this.taskMonitor.requestCancel();
            this.currentStatus = Status.CANCELLING;
        }
    }

    public double getCPUSecondsElapsed() {
        double secondsElapsed = 0.0;
        secondsElapsed = this.currentStatus == Status.NOT_STARTED ? 0.0 : (this.isComplete() ? TimingUtils.nanoTimeToSeconds(this.taskEndTime - this.taskStartTime) : TimingUtils.nanoTimeToSeconds(TimingUtils.getNanoCPUTimeOfThread(this.getId()) - this.taskStartTime));
        return secondsElapsed > 0.0 ? secondsElapsed : 0.0;
    }

    public Task getTask() {
        return this.runningTask;
    }

    public String getCurrentStatusString() {
        switch (this.currentStatus) {
            case NOT_STARTED: {
                return "not started";
            }
            case RUNNING: {
                return "running";
            }
            case PAUSED: {
                return "paused";
            }
            case CANCELLING: {
                return "cancelling";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case COMPLETED: {
                return "completed";
            }
            case FAILED: {
                return "failed";
            }
        }
        return "unknown";
    }

    public String getCurrentActivityString() {
        return this.isComplete() || this.currentStatus == Status.NOT_STARTED ? "" : this.taskMonitor.getCurrentActivityDescription();
    }

    public double getCurrentActivityFracComplete() {
        switch (this.currentStatus) {
            case NOT_STARTED: {
                return 0.0;
            }
            case RUNNING: 
            case PAUSED: 
            case CANCELLING: {
                return this.taskMonitor.getCurrentActivityFractionComplete();
            }
            case CANCELLED: 
            case COMPLETED: 
            case FAILED: {
                return 1.0;
            }
        }
        return 0.0;
    }

    public boolean isComplete() {
        return this.currentStatus == Status.CANCELLED || this.currentStatus == Status.COMPLETED || this.currentStatus == Status.FAILED;
    }

    public Object getFinalResult() {
        return this.finalResult;
    }

    public void addTaskCompletionListener(TaskCompletionListener tcl) {
        this.completionListeners.add(tcl);
    }

    public void removeTaskCompletionListener(TaskCompletionListener tcl) {
        this.completionListeners.remove(tcl);
    }

    protected void fireTaskCompleted() {
        for (TaskCompletionListener listener : this.completionListeners) {
            listener.taskCompleted(this);
        }
    }

    public void getPreview(ResultPreviewListener previewer) {
        this.taskMonitor.requestResultPreview(previewer);
        this.latestPreviewGrabTime = this.getCPUSecondsElapsed();
    }

    public Object getLatestResultPreview() {
        return this.taskMonitor.getLatestResultPreview();
    }

    public double getLatestPreviewGrabTimeSeconds() {
        return this.latestPreviewGrabTime;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NOT_STARTED,
        RUNNING,
        PAUSED,
        CANCELLING,
        CANCELLED,
        COMPLETED,
        FAILED;

    }
}

