/*
 * Decompiled with CFR 0.152.
 */
package moa.options;

import javax.swing.JComponent;
import moa.gui.FloatOptionEditComponent;
import moa.options.AbstractOption;

public class FloatOption
extends AbstractOption {
    private static final long serialVersionUID = 1L;
    protected double currentVal;
    protected double defaultVal;
    protected double minVal;
    protected double maxVal;

    public FloatOption(String name, char cliChar, String purpose, double defaultVal) {
        this(name, cliChar, purpose, defaultVal, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public FloatOption(String name, char cliChar, String purpose, double defaultVal, double minVal, double maxVal) {
        super(name, cliChar, purpose);
        this.defaultVal = defaultVal;
        this.minVal = minVal;
        this.maxVal = maxVal;
        this.resetToDefault();
    }

    public void setValue(double v) {
        if (v < this.minVal) {
            throw new IllegalArgumentException("Option " + this.getName() + " cannot be less than " + this.minVal + ", out of range: " + v);
        }
        if (v > this.maxVal) {
            throw new IllegalArgumentException("Option " + this.getName() + " cannot be greater than " + this.maxVal + ", out of range: " + v);
        }
        this.currentVal = v;
    }

    public double getValue() {
        return this.currentVal;
    }

    public double getMinValue() {
        return this.minVal;
    }

    public double getMaxValue() {
        return this.maxVal;
    }

    public String getDefaultCLIString() {
        return FloatOption.doubleToCLIString(this.defaultVal);
    }

    public String getValueAsCLIString() {
        return FloatOption.doubleToCLIString(this.currentVal);
    }

    public void setValueViaCLIString(String s) {
        this.setValue(FloatOption.cliStringToDouble(s));
    }

    public static double cliStringToDouble(String s) {
        return Double.parseDouble(s.trim());
    }

    public static String doubleToCLIString(double d) {
        return Double.toString(d);
    }

    public JComponent getEditComponent() {
        return new FloatOptionEditComponent(this);
    }
}

