/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import moa.cluster.Clustering;
import moa.gui.visualization.DataPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipMatrix {
    HashMap<Integer, Integer> classmap;
    int[][] cluster_class_weights;
    int[] cluster_sums;
    int[] class_sums;
    int total_entries;
    int[] class_distribution;
    int total_class_entries;
    int initalBuildTimestamp = -1;

    public MembershipMatrix(Clustering foundClustering, ArrayList<DataPoint> points) {
        this.classmap = Clustering.classValues(points);
        int numClasses = this.classmap.size();
        int numCluster = foundClustering.size() + 1;
        this.cluster_class_weights = new int[numCluster][numClasses];
        this.class_distribution = new int[numClasses];
        this.cluster_sums = new int[numCluster];
        this.class_sums = new int[numClasses];
        this.total_entries = 0;
        this.total_class_entries = points.size();
        for (int p = 0; p < points.size(); ++p) {
            int worklabel;
            int n = worklabel = this.classmap.get((int)points.get(p).classValue()).intValue();
            this.class_distribution[n] = this.class_distribution[n] + 1;
            boolean covered = false;
            for (int c = 0; c < numCluster - 1; ++c) {
                double prob = foundClustering.get(c).getInclusionProbability(points.get(p));
                if (!(prob >= 1.0)) continue;
                int[] nArray = this.cluster_class_weights[c];
                int n2 = worklabel;
                nArray[n2] = nArray[n2] + 1;
                int n3 = worklabel;
                this.class_sums[n3] = this.class_sums[n3] + 1;
                int n4 = c;
                this.cluster_sums[n4] = this.cluster_sums[n4] + 1;
                ++this.total_entries;
                covered = true;
            }
            if (covered) continue;
            int[] nArray = this.cluster_class_weights[numCluster - 1];
            int n5 = worklabel;
            nArray[n5] = nArray[n5] + 1;
            int n6 = worklabel;
            this.class_sums[n6] = this.class_sums[n6] + 1;
            int n7 = numCluster - 1;
            this.cluster_sums[n7] = this.cluster_sums[n7] + 1;
            ++this.total_entries;
        }
        this.initalBuildTimestamp = points.get(0).getTimestamp();
    }

    public int getClusterClassWeight(int i, int j) {
        return this.cluster_class_weights[i][j];
    }

    public int getClusterSum(int i) {
        return this.cluster_sums[i];
    }

    public int getClassSum(int j) {
        return this.class_sums[j];
    }

    public int getClassDistribution(int j) {
        return this.class_distribution[j];
    }

    public int getClusterClassWeightByLabel(int cluster, int classLabel) {
        return this.cluster_class_weights[cluster][this.classmap.get(classLabel)];
    }

    public int getClassSumByLabel(int classLabel) {
        return this.class_sums[this.classmap.get(classLabel)];
    }

    public int getClassDistributionByLabel(int classLabel) {
        return this.class_distribution[this.classmap.get(classLabel)];
    }

    public int getTotalEntries() {
        return this.total_entries;
    }

    public int getNumClasses() {
        return this.classmap.size();
    }

    public boolean hasNoiseClass() {
        return this.classmap.containsKey(-1);
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("Membership Matrix\n");
        for (i = 0; i < this.cluster_class_weights.length; ++i) {
            for (int j = 0; j < this.cluster_class_weights[i].length; ++j) {
                sb.append(this.cluster_class_weights[i][j] + "\t ");
            }
            sb.append("| " + this.cluster_sums[i] + "\n");
        }
        for (i = 0; i < this.class_sums.length; ++i) {
            sb.append(this.class_sums[i] + "\t ");
        }
        sb.append("| " + this.total_entries + "\n");
        sb.append("Real class distribution \n");
        for (i = 0; i < this.class_distribution.length; ++i) {
            sb.append(this.class_distribution[i] + "\t ");
        }
        sb.append("| " + this.total_class_entries + "\n");
        return sb.toString();
    }

    public int getInitalBuildTimestamp() {
        return this.initalBuildTimestamp;
    }
}

