## ----eval=FALSE---------------------------------------------------------------
# devtools::install_github("https://github.com/marciagraca/RCMsize")
# remotes::install_github("https://github.com/marciagraca/RCMsize")

## ----setup--------------------------------------------------------------------
library(RCMsize)

## -----------------------------------------------------------------------------
prob_seropositive(0.03, 0.01, 45)

## -----------------------------------------------------------------------------
seroprevalence(rep(1 / 80, 80), 80, 0.03, 0.01)

## -----------------------------------------------------------------------------
IC_SP(0.25, 100, conf.level = 0.95, method = "asymptotic")

## -----------------------------------------------------------------------------
IC_SP_Waldcc(0.25, 100, conf.level = 0.95)

## -----------------------------------------------------------------------------
IC_SCR(c(0.1, 0.2), 0.01, rep(1 / 80, 80), 80, limits = c(0, 1))

## -----------------------------------------------------------------------------
A_max <- 80
age_distribution <- rep(1 / A_max, A_max)
sample_s(0.03, 1, 0.01, age_distribution, A_max, limits = c(0, 1))

