/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.function.tobject.ObjectFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import cern.colt.function.tobject.ObjectProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix3D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SelectedDenseObjectMatrix3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseObjectMatrix3D
extends ObjectMatrix3D {
    private static final long serialVersionUID = 1L;
    protected Object[] elements;

    public DenseObjectMatrix3D(Object[][][] objectArray) {
        this(objectArray.length, objectArray.length == 0 ? 0 : objectArray[0].length, objectArray.length == 0 ? 0 : (objectArray[0].length == 0 ? 0 : objectArray[0][0].length));
        this.assign(objectArray);
    }

    public DenseObjectMatrix3D(int n, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = new Object[n * n2 * n3];
    }

    protected DenseObjectMatrix3D(int n, int n2, int n3, Object[] objectArray, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) {
        this.setUp(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.elements = objectArray;
        this.isNoView = !bl;
    }

    public Object aggregate(final ObjectObjectFunction objectObjectFunction, final ObjectFunction objectFunction) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        Object object = null;
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object object = objectFunction.apply(DenseObjectMatrix3D.this.elements[n + n4 * DenseObjectMatrix3D.this.sliceStride]);
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseObjectMatrix3D.this.rows; ++j) {
                                for (int k = n2; k < DenseObjectMatrix3D.this.columns; ++k) {
                                    object = objectObjectFunction.apply(object, objectFunction.apply(DenseObjectMatrix3D.this.elements[n + i * DenseObjectMatrix3D.this.sliceStride + j * DenseObjectMatrix3D.this.rowStride + k * DenseObjectMatrix3D.this.columnStride]));
                                }
                                n2 = 0;
                            }
                        }
                        return object;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            object = objectFunction.apply(this.elements[n]);
            int n6 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n6; k < this.columns; ++k) {
                        object = objectObjectFunction.apply(object, objectFunction.apply(this.elements[n + i * this.sliceStride + j * this.rowStride + k * this.columnStride]));
                    }
                    n6 = 0;
                }
            }
        }
        return object;
    }

    public Object aggregate(final ObjectObjectFunction objectObjectFunction, final ObjectFunction objectFunction, final ObjectProcedure objectProcedure) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        Object object = null;
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object object = DenseObjectMatrix3D.this.elements[n + n4 * DenseObjectMatrix3D.this.sliceStride];
                        Object object2 = 0;
                        if (objectProcedure.apply(object)) {
                            object2 = objectObjectFunction.apply(object2, objectFunction.apply(object));
                        }
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseObjectMatrix3D.this.rows; ++j) {
                                for (int k = n2; k < DenseObjectMatrix3D.this.columns; ++k) {
                                    object = DenseObjectMatrix3D.this.elements[n + i * DenseObjectMatrix3D.this.sliceStride + j * DenseObjectMatrix3D.this.rowStride + k * DenseObjectMatrix3D.this.columnStride];
                                    if (objectProcedure.apply(object)) {
                                        object2 = objectObjectFunction.apply(object2, objectFunction.apply(object));
                                    }
                                    n2 = 0;
                                }
                            }
                        }
                        return object2;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            Object object2 = this.elements[n];
            if (objectProcedure.apply(object2)) {
                object = objectObjectFunction.apply(object, objectFunction.apply(object2));
            }
            int n6 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n6; k < this.columns; ++k) {
                        object2 = this.elements[n + i * this.sliceStride + j * this.rowStride + k * this.columnStride];
                        if (objectProcedure.apply(object2)) {
                            object = objectObjectFunction.apply(object, objectFunction.apply(object2));
                        }
                        n6 = 0;
                    }
                }
            }
        }
        return object;
    }

    public Object aggregate(final ObjectObjectFunction objectObjectFunction, final ObjectFunction objectFunction, IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        if (intArrayList.size() == 0 || intArrayList2.size() == 0 || intArrayList3.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final int[] nArray3 = intArrayList3.elements();
        final int n2 = (int)this.index(0, 0, 0);
        Object object = null;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n3 = Math.min(n3, n);
            Future[] futureArray = new Future[n3];
            int n4 = n / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? n : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object object = objectFunction.apply(DenseObjectMatrix3D.this.elements[n2 + nArray[n5] * DenseObjectMatrix3D.this.sliceStride + nArray2[n5] * DenseObjectMatrix3D.this.rowStride + nArray3[n5] * DenseObjectMatrix3D.this.columnStride]);
                        for (int i = n5 + 1; i < n6; ++i) {
                            Object object2 = DenseObjectMatrix3D.this.elements[n2 + nArray[i] * DenseObjectMatrix3D.this.sliceStride + nArray2[i] * DenseObjectMatrix3D.this.rowStride + nArray3[i] * DenseObjectMatrix3D.this.columnStride];
                            object = objectObjectFunction.apply(object, objectFunction.apply(object2));
                        }
                        return object;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            object = objectFunction.apply(this.elements[n2 + nArray[0] * this.sliceStride + nArray2[0] * this.rowStride + nArray3[0] * this.columnStride]);
            for (int i = 1; i < n; ++i) {
                Object object2 = this.elements[n2 + nArray[i] * this.sliceStride + nArray2[i] * this.rowStride + nArray3[i] * this.columnStride];
                object = objectObjectFunction.apply(object, objectFunction.apply(object2));
            }
        }
        return object;
    }

    public Object aggregate(ObjectMatrix3D objectMatrix3D, final ObjectObjectFunction objectObjectFunction, final ObjectObjectFunction objectObjectFunction2) {
        if (!(objectMatrix3D instanceof DenseObjectMatrix3D)) {
            return super.aggregate(objectMatrix3D, objectObjectFunction, objectObjectFunction2);
        }
        this.checkShape(objectMatrix3D);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        Object object = null;
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)objectMatrix3D.index(0, 0, 0);
        final int n3 = objectMatrix3D.sliceStride();
        final int n4 = objectMatrix3D.rowStride();
        final int n5 = objectMatrix3D.columnStride();
        final Object[] objectArray = (Object[])objectMatrix3D.elements();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n6 = Math.min(n6, this.slices);
            Future[] futureArray = new Future[n6];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        int n6 = n + n8 * DenseObjectMatrix3D.this.sliceStride;
                        int n22 = n2 + n8 * n3;
                        Object object = objectObjectFunction2.apply(DenseObjectMatrix3D.this.elements[n6], objectArray[n22]);
                        int n32 = 1;
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseObjectMatrix3D.this.rows; ++j) {
                                for (int k = n32; k < DenseObjectMatrix3D.this.columns; ++k) {
                                    n6 = n + i * DenseObjectMatrix3D.this.sliceStride + j * DenseObjectMatrix3D.this.rowStride + k * DenseObjectMatrix3D.this.columnStride;
                                    n22 = n2 + i * n3 + j * n4 + k * n5;
                                    object = objectObjectFunction.apply(object, objectObjectFunction2.apply(DenseObjectMatrix3D.this.elements[n6], objectArray[n22]));
                                }
                                n32 = 0;
                            }
                        }
                        return object;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            object = objectObjectFunction2.apply(this.getQuick(0, 0, 0), objectMatrix3D.getQuick(0, 0, 0));
            int n10 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n10; k < this.columns; ++k) {
                        int n11 = n + i * this.sliceStride + j * this.rowStride + k * this.columnStride;
                        int n12 = n2 + i * n3 + j * n4 + k * n5;
                        object = objectObjectFunction.apply(object, objectObjectFunction2.apply(this.elements[n11], objectArray[n12]));
                    }
                    n10 = 0;
                }
            }
        }
        return object;
    }

    public ObjectMatrix3D assign(final Object[][][] objectArray) {
        if (objectArray.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + objectArray.length + "slices()=" + this.slices());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                int n2;
                n = Math.min(n, this.slices);
                Future[] futureArray = new Future[n];
                int n3 = this.slices / n;
                for (n2 = 0; n2 < n; ++n2) {
                    final int n4 = n2 * n3;
                    final int n5 = n2 == n - 1 ? this.slices : n4 + n3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n4 * DenseObjectMatrix3D.this.sliceStride;
                            for (int i = n4; i < n5; ++i) {
                                Object[][] objectArray3 = objectArray[i];
                                if (objectArray3.length != DenseObjectMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + objectArray3.length + "rows()=" + DenseObjectMatrix3D.this.rows());
                                }
                                for (int j = 0; j < DenseObjectMatrix3D.this.rows; ++j) {
                                    Object[] objectArray2 = objectArray3[j];
                                    if (objectArray2.length != DenseObjectMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray2.length + "columns()=" + DenseObjectMatrix3D.this.columns());
                                    }
                                    System.arraycopy(objectArray2, 0, DenseObjectMatrix3D.this.elements, n, DenseObjectMatrix3D.this.columns);
                                    n += DenseObjectMatrix3D.this.columns;
                                }
                            }
                        }
                    });
                }
                try {
                    for (n2 = 0; n2 < n; ++n2) {
                        futureArray[n2].get();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                int n6 = 0;
                for (int i = 0; i < this.slices; ++i) {
                    Object[][] objectArray2 = objectArray[i];
                    if (objectArray2.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + objectArray2.length + "rows()=" + this.rows());
                    }
                    for (int j = 0; j < this.rows; ++j) {
                        Object[] objectArray3 = objectArray2[j];
                        if (objectArray3.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray3.length + "columns()=" + this.columns());
                        }
                        System.arraycopy(objectArray3, 0, this.elements, n6, this.columns);
                        n6 += this.columns;
                    }
                }
            }
        } else {
            final int n7 = (int)this.index(0, 0, 0);
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                int n8;
                n = Math.min(n, this.slices);
                Future[] futureArray = new Future[n];
                int n9 = this.slices / n;
                for (n8 = 0; n8 < n; ++n8) {
                    final int n10 = n8 * n9;
                    final int n11 = n8 == n - 1 ? this.slices : n10 + n9;
                    futureArray[n8] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n10; i < n11; ++i) {
                                Object[][] objectArray3 = objectArray[i];
                                if (objectArray3.length != DenseObjectMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + objectArray3.length + "rows()=" + DenseObjectMatrix3D.this.rows());
                                }
                                for (int j = 0; j < DenseObjectMatrix3D.this.rows; ++j) {
                                    int n = n7 + i * DenseObjectMatrix3D.this.sliceStride + j * DenseObjectMatrix3D.this.rowStride;
                                    Object[] objectArray2 = objectArray3[j];
                                    if (objectArray2.length != DenseObjectMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray2.length + "columns()=" + DenseObjectMatrix3D.this.columns());
                                    }
                                    for (int k = 0; k < DenseObjectMatrix3D.this.columns; ++k) {
                                        DenseObjectMatrix3D.this.elements[n] = objectArray2[k];
                                        n += DenseObjectMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    for (n8 = 0; n8 < n; ++n8) {
                        futureArray[n8].get();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                for (int i = 0; i < this.slices; ++i) {
                    Object[][] objectArray4 = objectArray[i];
                    if (objectArray4.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + objectArray4.length + "rows()=" + this.rows());
                    }
                    for (int j = 0; j < this.rows; ++j) {
                        int n12 = n7 + i * this.sliceStride + j * this.rowStride;
                        Object[] objectArray5 = objectArray4[j];
                        if (objectArray5.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray5.length + "columns()=" + this.columns());
                        }
                        for (int k = 0; k < this.columns; ++k) {
                            this.elements[n12] = objectArray5[k];
                            n12 += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(final Object[] objectArray) {
        if ((long)objectArray.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + objectArray.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(objectArray, 0, this.elements, 0, objectArray.length);
        } else {
            final int n2 = (int)this.index(0, 0, 0);
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                n = Math.min(n, this.slices);
                Future[] futureArray = new Future[n];
                int n3 = this.slices / n;
                for (int i = 0; i < n; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n - 1 ? this.slices : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n4 * DenseObjectMatrix3D.this.rows * DenseObjectMatrix3D.this.columns;
                            for (int i = n4; i < n5; ++i) {
                                for (int j = 0; j < DenseObjectMatrix3D.this.rows; ++j) {
                                    int n22 = n2 + i * DenseObjectMatrix3D.this.sliceStride + j * DenseObjectMatrix3D.this.rowStride;
                                    for (int k = 0; k < DenseObjectMatrix3D.this.columns; ++k) {
                                        DenseObjectMatrix3D.this.elements[n22] = objectArray[n++];
                                        n22 += DenseObjectMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n6 = 0;
                for (int i = 0; i < this.slices; ++i) {
                    for (int j = 0; j < this.rows; ++j) {
                        int n7 = n2 + i * this.sliceStride + j * this.rowStride;
                        for (int k = 0; k < this.columns; ++k) {
                            this.elements[n7] = objectArray[n6++];
                            n7 += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(final Object object) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseObjectMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseObjectMatrix3D.this.sliceStride + j * DenseObjectMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseObjectMatrix3D.this.columns; ++k) {
                                    DenseObjectMatrix3D.this.elements[n2] = object;
                                    n2 += DenseObjectMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n6] = object;
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(final ObjectProcedure objectProcedure, final ObjectFunction objectFunction) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseObjectMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseObjectMatrix3D.this.sliceStride + j * DenseObjectMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseObjectMatrix3D.this.columns; ++k) {
                                    Object object = DenseObjectMatrix3D.this.elements[n2];
                                    if (objectProcedure.apply(object)) {
                                        DenseObjectMatrix3D.this.elements[n2] = objectFunction.apply(object);
                                    }
                                    n2 += DenseObjectMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        Object object = this.elements[n6];
                        if (objectProcedure.apply(object)) {
                            this.elements[n6] = objectFunction.apply(object);
                        }
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(final ObjectProcedure objectProcedure, final Object object) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseObjectMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseObjectMatrix3D.this.sliceStride + j * DenseObjectMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseObjectMatrix3D.this.columns; ++k) {
                                    Object object2 = DenseObjectMatrix3D.this.elements[n2];
                                    if (objectProcedure.apply(object2)) {
                                        DenseObjectMatrix3D.this.elements[n2] = object;
                                    }
                                    n2 += DenseObjectMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        Object object2 = this.elements[n6];
                        if (objectProcedure.apply(object2)) {
                            this.elements[n6] = object;
                        }
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(ObjectMatrix3D objectMatrix3D) {
        ObjectMatrix3D objectMatrix3D2;
        if (!(objectMatrix3D instanceof DenseObjectMatrix3D)) {
            return super.assign(objectMatrix3D);
        }
        DenseObjectMatrix3D denseObjectMatrix3D = (DenseObjectMatrix3D)objectMatrix3D;
        if (denseObjectMatrix3D == this) {
            return this;
        }
        this.checkShape(denseObjectMatrix3D);
        if (this.haveSharedCells(denseObjectMatrix3D)) {
            objectMatrix3D2 = denseObjectMatrix3D.copy();
            if (!(objectMatrix3D2 instanceof DenseObjectMatrix3D)) {
                super.assign(objectMatrix3D);
                return this;
            }
            denseObjectMatrix3D = objectMatrix3D2;
        }
        objectMatrix3D2 = denseObjectMatrix3D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseObjectMatrix3D.isNoView) {
            System.arraycopy(((DenseObjectMatrix3D)objectMatrix3D2).elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        final int n2 = (int)this.index(0, 0, 0);
        final int n3 = (int)((DenseObjectMatrix3D)objectMatrix3D2).index(0, 0, 0);
        final int n4 = ((DenseObjectMatrix3D)objectMatrix3D2).sliceStride;
        final int n5 = ((DenseObjectMatrix3D)objectMatrix3D2).rowStride;
        final int n6 = ((DenseObjectMatrix3D)objectMatrix3D2).columnStride;
        final Object[] objectArray = ((DenseObjectMatrix3D)objectMatrix3D2).elements;
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n7;
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n8 = this.slices / n;
            for (n7 = 0; n7 < n; ++n7) {
                final int n9 = n7 * n8;
                final int n10 = n7 == n - 1 ? this.slices : n9 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n9; i < n10; ++i) {
                            for (int j = 0; j < DenseObjectMatrix3D.this.rows; ++j) {
                                int n = n2 + i * DenseObjectMatrix3D.this.sliceStride + j * DenseObjectMatrix3D.this.rowStride;
                                int n22 = n3 + i * n4 + j * n5;
                                for (int k = 0; k < DenseObjectMatrix3D.this.columns; ++k) {
                                    DenseObjectMatrix3D.this.elements[n] = objectArray[n22];
                                    n += DenseObjectMatrix3D.this.columnStride;
                                    n22 += n6;
                                }
                            }
                        }
                    }
                });
            }
            try {
                for (n7 = 0; n7 < n; ++n7) {
                    futureArray[n7].get();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n11 = n2 + i * this.sliceStride + j * this.rowStride;
                    int n12 = n3 + i * n4 + j * n5;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n11] = objectArray[n12];
                        n11 += this.columnStride;
                        n12 += n6;
                    }
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(final ObjectFunction objectFunction) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseObjectMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseObjectMatrix3D.this.sliceStride + j * DenseObjectMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseObjectMatrix3D.this.columns; ++k) {
                                    DenseObjectMatrix3D.this.elements[n2] = objectFunction.apply(DenseObjectMatrix3D.this.elements[n2]);
                                    n2 += DenseObjectMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n6] = objectFunction.apply(this.elements[n6]);
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(ObjectMatrix3D objectMatrix3D, final ObjectObjectFunction objectObjectFunction) {
        if (!(objectMatrix3D instanceof DenseObjectMatrix3D)) {
            super.assign(objectMatrix3D, objectObjectFunction);
            return this;
        }
        this.checkShape(objectMatrix3D);
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)objectMatrix3D.index(0, 0, 0);
        final int n3 = objectMatrix3D.sliceStride();
        final int n4 = objectMatrix3D.rowStride();
        final int n5 = objectMatrix3D.columnStride();
        final Object[] objectArray = (Object[])objectMatrix3D.elements();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n6 = Math.min(n6, this.slices);
            Future[] futureArray = new Future[n6];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseObjectMatrix3D.this.rows; ++j) {
                                int n6 = n + i * DenseObjectMatrix3D.this.sliceStride + j * DenseObjectMatrix3D.this.rowStride;
                                int n22 = n2 + i * n3 + j * n4;
                                for (int k = 0; k < DenseObjectMatrix3D.this.columns; ++k) {
                                    DenseObjectMatrix3D.this.elements[n6] = objectObjectFunction.apply(DenseObjectMatrix3D.this.elements[n6], objectArray[n22]);
                                    n6 += DenseObjectMatrix3D.this.columnStride;
                                    n22 += n5;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n10 = n + i * this.sliceStride + j * this.rowStride;
                    int n11 = n2 + i * n3 + j * n4;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n10] = objectObjectFunction.apply(this.elements[n10], objectArray[n11]);
                        n10 += this.columnStride;
                        n11 += n5;
                    }
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(ObjectMatrix3D objectMatrix3D, final ObjectObjectFunction objectObjectFunction, IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        if (!(objectMatrix3D instanceof DenseObjectMatrix3D)) {
            super.assign(objectMatrix3D, objectObjectFunction);
            return this;
        }
        this.checkShape(objectMatrix3D);
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)objectMatrix3D.index(0, 0, 0);
        final int n3 = objectMatrix3D.sliceStride();
        final int n4 = objectMatrix3D.rowStride();
        final int n5 = objectMatrix3D.columnStride();
        final Object[] objectArray = (Object[])objectMatrix3D.elements();
        int n6 = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final int[] nArray3 = intArrayList3.elements();
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (n7 > 1 && n6 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n7 = Math.min(n7, n6);
            Future[] futureArray = new Future[n7];
            int n8 = n6 / n7;
            for (int i = 0; i < n7; ++i) {
                final int n9 = i * n8;
                final int n10 = i == n7 - 1 ? n6 : n9 + n8;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n9; i < n10; ++i) {
                            int n6 = n + nArray[i] * DenseObjectMatrix3D.this.sliceStride + nArray2[i] * DenseObjectMatrix3D.this.rowStride + nArray3[i] * DenseObjectMatrix3D.this.columnStride;
                            int n22 = n2 + nArray[i] * n3 + nArray2[i] * n4 + nArray3[i] * n5;
                            DenseObjectMatrix3D.this.elements[n6] = objectObjectFunction.apply(DenseObjectMatrix3D.this.elements[n6], objectArray[n22]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n6; ++i) {
                int n11 = n + nArray[i] * this.sliceStride + nArray2[i] * this.rowStride + nArray3[i] * this.columnStride;
                int n12 = n2 + nArray[i] * n3 + nArray2[i] * n4 + nArray3[i] * n5;
                this.elements[n11] = objectObjectFunction.apply(this.elements[n11], objectArray[n12]);
            }
        }
        return this;
    }

    public Object[] elements() {
        return this.elements;
    }

    public Object getQuick(int n, int n2, int n3) {
        return this.elements[this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride];
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix3D objectMatrix3D) {
        if (objectMatrix3D instanceof SelectedDenseObjectMatrix3D) {
            SelectedDenseObjectMatrix3D selectedDenseObjectMatrix3D = (SelectedDenseObjectMatrix3D)objectMatrix3D;
            return this.elements == selectedDenseObjectMatrix3D.elements;
        }
        if (objectMatrix3D instanceof DenseObjectMatrix3D) {
            DenseObjectMatrix3D denseObjectMatrix3D = (DenseObjectMatrix3D)objectMatrix3D;
            return this.elements == denseObjectMatrix3D.elements;
        }
        return false;
    }

    public long index(int n, int n2, int n3) {
        return this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
    }

    public ObjectMatrix3D like(int n, int n2, int n3) {
        return new DenseObjectMatrix3D(n, n2, n3);
    }

    protected ObjectMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        return new DenseObjectMatrix2D(n, n2, this.elements, n3, n4, n5, n6, true);
    }

    public void setQuick(int n, int n2, int n3, Object object) {
        this.elements[this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride] = object;
    }

    public ObjectMatrix1D vectorize() {
        DenseObjectMatrix1D denseObjectMatrix1D = new DenseObjectMatrix1D((int)this.size());
        int n = this.rows * this.columns;
        for (int i = 0; i < this.slices; ++i) {
            denseObjectMatrix1D.viewPart(i * n, n).assign(this.viewSlice(i).vectorize());
        }
        return denseObjectMatrix1D;
    }

    protected ObjectMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedDenseObjectMatrix3D(this.elements, nArray, nArray2, nArray3, 0);
    }

    public ObjectMatrix2D like2D(int n, int n2) {
        return new DenseObjectMatrix2D(n, n2);
    }
}

