/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.map.tfloat.AbstractLongFloatMap;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix3D;

class SelectedSparseFloatMatrix1D
extends FloatMatrix1D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongFloatMap elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedSparseFloatMatrix1D(AbstractLongFloatMap abstractLongFloatMap, int[] nArray) {
        this(nArray.length, abstractLongFloatMap, 0, 1, nArray, 0);
    }

    protected SelectedSparseFloatMatrix1D(int n, AbstractLongFloatMap abstractLongFloatMap, int n2, int n3, int[] nArray, int n4) {
        this.setUp(n, n2, n3);
        this.elements = abstractLongFloatMap;
        this.offsets = nArray;
        this.offset = n4;
        this.isNoView = false;
    }

    public AbstractLongFloatMap elements() {
        return this.elements;
    }

    public float getQuick(int n) {
        return this.elements.get((long)this.offset + (long)this.offsets[this.zero + n * this.stride]);
    }

    public long index(int n) {
        return (long)this.offset + (long)this.offsets[this.zero + n * this.stride];
    }

    public FloatMatrix1D like(int n) {
        return new SparseFloatMatrix1D(n);
    }

    public FloatMatrix2D like2D(int n, int n2) {
        return new SparseFloatMatrix2D(n, n2);
    }

    public FloatMatrix2D reshape(int n, int n2) {
        if (n * n2 != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        SparseFloatMatrix2D sparseFloatMatrix2D = new SparseFloatMatrix2D(n, n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                ((FloatMatrix2D)sparseFloatMatrix2D).setQuick(j, i, this.getQuick(n3++));
            }
        }
        return sparseFloatMatrix2D;
    }

    public FloatMatrix3D reshape(int n, int n2, int n3) {
        if (n * n2 * n3 != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        SparseFloatMatrix3D sparseFloatMatrix3D = new SparseFloatMatrix3D(n, n2, n3);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    ((FloatMatrix3D)sparseFloatMatrix3D).setQuick(i, k, j, this.getQuick(n4++));
                }
            }
        }
        return sparseFloatMatrix3D;
    }

    public void setQuick(int n, float f) {
        long l = (long)this.offset + (long)this.offsets[this.zero + n * this.stride];
        if (f == 0.0f) {
            this.elements.removeKey(l);
        } else {
            this.elements.put(l, f);
        }
    }

    protected int _offset(int n) {
        return this.offsets[n];
    }

    protected boolean haveSharedCellsRaw(FloatMatrix1D floatMatrix1D) {
        if (floatMatrix1D instanceof SelectedSparseFloatMatrix1D) {
            SelectedSparseFloatMatrix1D selectedSparseFloatMatrix1D = (SelectedSparseFloatMatrix1D)floatMatrix1D;
            return this.elements == selectedSparseFloatMatrix1D.elements;
        }
        if (floatMatrix1D instanceof SparseFloatMatrix1D) {
            SparseFloatMatrix1D sparseFloatMatrix1D = (SparseFloatMatrix1D)floatMatrix1D;
            return this.elements == sparseFloatMatrix1D.elements;
        }
        return false;
    }

    protected void setUp(int n) {
        super.setUp(n);
        this.stride = 1;
        this.offset = 0;
    }

    protected FloatMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseFloatMatrix1D(this.elements, nArray);
    }
}

