/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat;

import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.function.tfloat.IntIntFloatFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfloat.FloatFactory1D;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix1DProcedure;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Random;
import junit.framework.TestCase;

public abstract class FloatMatrix2DTest
extends TestCase {
    protected FloatMatrix2D A;
    protected FloatMatrix2D B;
    protected FloatMatrix2D Bt;
    protected int NROWS = 13;
    protected int NCOLUMNS = 17;
    protected float TOL = 0.001f;
    protected static final Random random = new Random(0L);

    public FloatMatrix2DTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.createMatrices();
        this.populateMatrices();
    }

    protected abstract void createMatrices() throws Exception;

    protected void populateMatrices() {
        int n;
        int n2;
        ConcurrencyUtils.setThreadsBeginN_2D(1);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            for (n = 0; n < this.A.columns(); ++n) {
                this.A.setQuick(n2, n, (float)Math.random());
            }
        }
        for (n2 = 0; n2 < this.B.rows(); ++n2) {
            for (n = 0; n < this.B.columns(); ++n) {
                this.B.setQuick(n2, n, (float)Math.random());
            }
        }
        for (n2 = 0; n2 < this.Bt.rows(); ++n2) {
            for (n = 0; n < this.Bt.columns(); ++n) {
                this.Bt.setQuick(n2, n, (float)Math.random());
            }
        }
    }

    protected void tearDown() throws Exception {
        this.Bt = null;
        this.B = null;
        this.A = null;
    }

    public void testAggregateFloatFloatFunctionFloatFunction() {
        float f = 0.0f;
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                float f2 = this.A.getQuick(i, j);
                f += f2 * f2;
            }
        }
        float f3 = this.A.aggregate(FloatFunctions.plus, FloatFunctions.square);
        FloatMatrix2DTest.assertEquals((float)f, (float)f3, (float)this.TOL);
    }

    public void testAggregateFloatFloatFunctionFloatFunctionFloatProcedure() {
        FloatProcedure floatProcedure = new FloatProcedure(){

            public boolean apply(float f) {
                return (double)Math.abs(f) > 0.2;
            }
        };
        float f = 0.0f;
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                float f2 = this.A.getQuick(i, j);
                if (!((double)Math.abs(f2) > 0.2)) continue;
                f += f2 * f2;
            }
        }
        float f3 = this.A.aggregate(FloatFunctions.plus, FloatFunctions.square, floatProcedure);
        FloatMatrix2DTest.assertEquals((float)f, (float)f3, (float)this.TOL);
    }

    public void testAggregateFloatFloatFunctionFloatFunctionIntArrayListIntArrayList() {
        int n;
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (n = 0; n < this.A.columns(); ++n) {
                intArrayList.add(i);
                intArrayList2.add(n);
            }
        }
        float f = 0.0f;
        for (n = 0; n < this.A.rows(); ++n) {
            for (int i = 0; i < this.A.columns(); ++i) {
                float f2 = this.A.getQuick(n, i);
                f += f2 * f2;
            }
        }
        float f3 = this.A.aggregate(FloatFunctions.plus, FloatFunctions.square, intArrayList, intArrayList2);
        FloatMatrix2DTest.assertEquals((float)f, (float)f3, (float)this.TOL);
    }

    public void testAggregateFloatMatrix2DFloatFloatFunctionFloatFloatFunction() {
        float f = 0.0f;
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                float f2 = this.A.getQuick(i, j);
                float f3 = this.B.getQuick(i, j);
                f += f2 * f3;
            }
        }
        float f4 = this.A.aggregate(this.B, FloatFunctions.plus, FloatFunctions.mult);
        FloatMatrix2DTest.assertEquals((float)f, (float)f4, (float)this.TOL);
    }

    public void testAssignFloat() {
        float f = (float)Math.random();
        this.A.assign(f);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                FloatMatrix2DTest.assertEquals((float)f, (float)this.A.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testAssignFloatArrayArray() {
        int n;
        int n2;
        float[][] fArray = new float[this.A.rows()][this.A.columns()];
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            for (n = 0; n < this.A.columns(); ++n) {
                fArray[n2][n] = (float)Math.random();
            }
        }
        this.A.assign(fArray);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            FloatMatrix2DTest.assertTrue((this.A.columns() == fArray[n2].length ? 1 : 0) != 0);
            for (n = 0; n < this.A.columns(); ++n) {
                FloatMatrix2DTest.assertEquals((float)fArray[n2][n], (float)this.A.getQuick(n2, n), (float)this.TOL);
            }
        }
    }

    public void testAssignFloatFunction() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        this.A.assign(FloatFunctions.acos);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                float f = (float)Math.acos(floatMatrix2D.getQuick(i, j));
                FloatMatrix2DTest.assertEquals((float)f, (float)this.A.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testAssignFloatMatrix2D() {
        this.A.assign(this.B);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                FloatMatrix2DTest.assertEquals((float)this.B.getQuick(i, j), (float)this.A.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testAssignFloatMatrix2DFloatFloatFunction() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        this.A.assign(this.B, FloatFunctions.plus);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                FloatMatrix2DTest.assertEquals((float)(floatMatrix2D.getQuick(i, j) + this.B.getQuick(i, j)), (float)this.A.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testAssignFloatMatrix2DFloatFloatFunctionIntArrayListIntArrayList() {
        int n;
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (n = 0; n < this.A.columns(); ++n) {
                intArrayList.add(i);
                intArrayList2.add(n);
            }
        }
        FloatMatrix2D floatMatrix2D = this.A.copy();
        this.A.assign(this.B, FloatFunctions.div, intArrayList, intArrayList2);
        for (n = 0; n < this.A.rows(); ++n) {
            for (int i = 0; i < this.A.columns(); ++i) {
                FloatMatrix2DTest.assertEquals((float)(floatMatrix2D.getQuick(n, i) / this.B.getQuick(n, i)), (float)this.A.getQuick(n, i), (float)this.TOL);
            }
        }
    }

    public void testAssignFloatProcedureFloat() {
        FloatProcedure floatProcedure = new FloatProcedure(){

            public boolean apply(float f) {
                return (double)Math.abs(f) > 0.1;
            }
        };
        FloatMatrix2D floatMatrix2D = this.A.copy();
        this.A.assign(floatProcedure, -1.0f);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                if ((double)Math.abs(floatMatrix2D.getQuick(i, j)) > 0.1) {
                    FloatMatrix2DTest.assertEquals((double)-1.0, (double)this.A.getQuick(i, j), (double)this.TOL);
                    continue;
                }
                FloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)this.A.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testAssignFloatProcedureFloatFunction() {
        FloatProcedure floatProcedure = new FloatProcedure(){

            public boolean apply(float f) {
                return (double)Math.abs(f) > 0.1;
            }
        };
        FloatMatrix2D floatMatrix2D = this.A.copy();
        this.A.assign(floatProcedure, FloatFunctions.tan);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                if ((double)Math.abs(floatMatrix2D.getQuick(i, j)) > 0.1) {
                    FloatMatrix2DTest.assertEquals((double)Math.tan(floatMatrix2D.getQuick(i, j)), (double)this.A.getQuick(i, j), (double)this.TOL);
                    continue;
                }
                FloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)this.A.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        FloatMatrix2DTest.assertEquals((int)(this.A.rows() * this.A.columns()), (int)n);
    }

    public void testEqualsFloat() {
        float f = 1.0f;
        this.A.assign(f);
        boolean bl = this.A.equals(f);
        FloatMatrix2DTest.assertTrue((boolean)bl);
        bl = this.A.equals(2.0f);
        FloatMatrix2DTest.assertFalse((boolean)bl);
    }

    public void testEqualsObject() {
        boolean bl = this.A.equals(this.A);
        FloatMatrix2DTest.assertTrue((boolean)bl);
        bl = this.A.equals(this.B);
        FloatMatrix2DTest.assertFalse((boolean)bl);
    }

    public void testForEachNonZero() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        IntIntFloatFunction intIntFloatFunction = new IntIntFloatFunction(){

            public float apply(int n, int n2, float f) {
                return (float)Math.sqrt(f);
            }
        };
        this.A.forEachNonZero(intIntFloatFunction);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                FloatMatrix2DTest.assertEquals((double)Math.sqrt(floatMatrix2D.getQuick(i, j)), (double)this.A.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testMaxLocation() {
        this.A.assign(0.0f);
        this.A.setQuick(this.A.rows() / 3, this.A.columns() / 3, 0.7f);
        this.A.setQuick(this.A.rows() / 2, this.A.columns() / 2, 0.1f);
        float[] fArray = this.A.getMaxLocation();
        FloatMatrix2DTest.assertEquals((float)0.7f, (float)fArray[0], (float)this.TOL);
        FloatMatrix2DTest.assertEquals((int)(this.A.rows() / 3), (int)((int)fArray[1]));
        FloatMatrix2DTest.assertEquals((int)(this.A.columns() / 3), (int)((int)fArray[2]));
    }

    public void testMinLocation() {
        this.A.assign(0.0f);
        this.A.setQuick(this.A.rows() / 3, this.A.columns() / 3, -0.7f);
        this.A.setQuick(this.A.rows() / 2, this.A.columns() / 2, -0.1f);
        float[] fArray = this.A.getMinLocation();
        FloatMatrix2DTest.assertEquals((float)-0.7f, (float)fArray[0], (float)this.TOL);
        FloatMatrix2DTest.assertEquals((int)(this.A.rows() / 3), (int)((int)fArray[1]));
        FloatMatrix2DTest.assertEquals((int)(this.A.columns() / 3), (int)((int)fArray[2]));
    }

    public void testGetNegativeValues() {
        this.A.assign(0.0f);
        this.A.setQuick(this.A.rows() / 3, this.A.columns() / 3, -0.7f);
        this.A.setQuick(this.A.rows() / 2, this.A.columns() / 2, -0.1f);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        FloatArrayList floatArrayList = new FloatArrayList();
        this.A.getNegativeValues(intArrayList, intArrayList2, floatArrayList);
        FloatMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
        FloatMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
        FloatMatrix2DTest.assertEquals((int)2, (int)floatArrayList.size());
        FloatMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 3));
        FloatMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 2));
        FloatMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 3));
        FloatMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 2));
        FloatMatrix2DTest.assertTrue((boolean)floatArrayList.contains(-0.7f));
        FloatMatrix2DTest.assertTrue((boolean)floatArrayList.contains(-0.1f));
    }

    public void testGetNonZeros() {
        this.A.assign(0.0f);
        this.A.setQuick(this.A.rows() / 3, this.A.columns() / 3, 0.7f);
        this.A.setQuick(this.A.rows() / 2, this.A.columns() / 2, 0.1f);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        FloatArrayList floatArrayList = new FloatArrayList();
        this.A.getNonZeros(intArrayList, intArrayList2, floatArrayList);
        FloatMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
        FloatMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
        FloatMatrix2DTest.assertEquals((int)2, (int)floatArrayList.size());
        FloatMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 3));
        FloatMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 2));
        FloatMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 3));
        FloatMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 2));
        FloatMatrix2DTest.assertTrue((boolean)floatArrayList.contains(0.7f));
        FloatMatrix2DTest.assertTrue((boolean)floatArrayList.contains(0.1f));
    }

    public void testGetPositiveValues() {
        this.A.assign(0.0f);
        this.A.setQuick(this.A.rows() / 3, this.A.columns() / 3, 0.7f);
        this.A.setQuick(this.A.rows() / 2, this.A.columns() / 2, 0.1f);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        FloatArrayList floatArrayList = new FloatArrayList();
        this.A.getPositiveValues(intArrayList, intArrayList2, floatArrayList);
        FloatMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
        FloatMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
        FloatMatrix2DTest.assertEquals((int)2, (int)floatArrayList.size());
        FloatMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 3));
        FloatMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 2));
        FloatMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 3));
        FloatMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 2));
        FloatMatrix2DTest.assertTrue((boolean)floatArrayList.contains(0.7f));
        FloatMatrix2DTest.assertTrue((boolean)floatArrayList.contains(0.1f));
    }

    public void testToArray() {
        float[][] fArray = this.A.toArray();
        FloatMatrix2DTest.assertTrue((this.A.rows() == fArray.length ? 1 : 0) != 0);
        for (int i = 0; i < this.A.rows(); ++i) {
            FloatMatrix2DTest.assertTrue((this.A.columns() == fArray[i].length ? 1 : 0) != 0);
            for (int j = 0; j < this.A.columns(); ++j) {
                FloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(fArray[i][j] - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testVectorize() {
        FloatMatrix1D floatMatrix1D = this.A.vectorize();
        int n = 0;
        for (int i = 0; i < this.A.columns(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                FloatMatrix2DTest.assertEquals((float)this.A.getQuick(j, i), (float)floatMatrix1D.getQuick(n++), (float)this.TOL);
            }
        }
    }

    public void testViewColumn() {
        FloatMatrix1D floatMatrix1D = this.A.viewColumn(this.A.columns() / 2);
        FloatMatrix2DTest.assertEquals((long)this.A.rows(), (long)floatMatrix1D.size());
        for (int i = 0; i < this.A.rows(); ++i) {
            FloatMatrix2DTest.assertEquals((float)this.A.getQuick(i, this.A.columns() / 2), (float)floatMatrix1D.getQuick(i), (float)this.TOL);
        }
    }

    public void testViewColumnFlip() {
        FloatMatrix2D floatMatrix2D = this.A.viewColumnFlip();
        FloatMatrix2DTest.assertEquals((long)this.A.size(), (long)floatMatrix2D.size());
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                FloatMatrix2DTest.assertEquals((float)this.A.getQuick(i, this.A.columns() - 1 - j), (float)floatMatrix2D.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testViewDice() {
        FloatMatrix2D floatMatrix2D = this.A.viewDice();
        FloatMatrix2DTest.assertEquals((int)this.A.rows(), (int)floatMatrix2D.columns());
        FloatMatrix2DTest.assertEquals((int)this.A.columns(), (int)floatMatrix2D.rows());
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                FloatMatrix2DTest.assertEquals((float)this.A.getQuick(i, j), (float)floatMatrix2D.getQuick(j, i), (float)this.TOL);
            }
        }
    }

    public void testViewPart() {
        FloatMatrix2D floatMatrix2D = this.A.viewPart(this.A.rows() / 2, this.A.columns() / 2, this.A.rows() / 3, this.A.columns() / 3);
        FloatMatrix2DTest.assertEquals((int)(this.A.rows() / 3), (int)floatMatrix2D.rows());
        FloatMatrix2DTest.assertEquals((int)(this.A.columns() / 3), (int)floatMatrix2D.columns());
        for (int i = 0; i < this.A.rows() / 3; ++i) {
            for (int j = 0; j < this.A.columns() / 3; ++j) {
                FloatMatrix2DTest.assertEquals((float)this.A.getQuick(this.A.rows() / 2 + i, this.A.columns() / 2 + j), (float)floatMatrix2D.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testViewRow() {
        FloatMatrix1D floatMatrix1D = this.A.viewRow(this.A.rows() / 2);
        FloatMatrix2DTest.assertEquals((long)this.A.columns(), (long)floatMatrix1D.size());
        for (int i = 0; i < this.A.columns(); ++i) {
            FloatMatrix2DTest.assertEquals((float)this.A.getQuick(this.A.rows() / 2, i), (float)floatMatrix1D.getQuick(i), (float)this.TOL);
        }
    }

    public void testViewRowFlip() {
        FloatMatrix2D floatMatrix2D = this.A.viewRowFlip();
        FloatMatrix2DTest.assertEquals((long)this.A.size(), (long)floatMatrix2D.size());
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                FloatMatrix2DTest.assertEquals((float)this.A.getQuick(this.A.rows() - 1 - i, j), (float)floatMatrix2D.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testViewSelectionFloatMatrix1DProcedure() {
        this.A.assign(0.0f);
        this.A.setQuick(this.A.rows() / 4, 0, 2.0f);
        this.A.setQuick(this.A.rows() / 2, 0, 2.0f);
        FloatMatrix2D floatMatrix2D = this.A.viewSelection(new FloatMatrix1DProcedure(){

            public boolean apply(FloatMatrix1D floatMatrix1D) {
                return Math.abs(floatMatrix1D.getQuick(0) - 2.0f) < FloatMatrix2DTest.this.TOL;
            }
        });
        FloatMatrix2DTest.assertEquals((int)2, (int)floatMatrix2D.rows());
        FloatMatrix2DTest.assertEquals((int)this.A.columns(), (int)floatMatrix2D.columns());
        FloatMatrix2DTest.assertEquals((float)this.A.getQuick(this.A.rows() / 4, 0), (float)floatMatrix2D.getQuick(0, 0), (float)this.TOL);
        FloatMatrix2DTest.assertEquals((float)this.A.getQuick(this.A.rows() / 2, 0), (float)floatMatrix2D.getQuick(1, 0), (float)this.TOL);
    }

    public void testViewSelectionIntArrayIntArray() {
        int[] nArray = new int[]{this.A.rows() / 6, this.A.rows() / 5, this.A.rows() / 4, this.A.rows() / 3, this.A.rows() / 2};
        int[] nArray2 = new int[]{this.A.columns() / 6, this.A.columns() / 5, this.A.columns() / 4, this.A.columns() / 3, this.A.columns() / 2, this.A.columns() - 1};
        FloatMatrix2D floatMatrix2D = this.A.viewSelection(nArray, nArray2);
        FloatMatrix2DTest.assertEquals((int)nArray.length, (int)floatMatrix2D.rows());
        FloatMatrix2DTest.assertEquals((int)nArray2.length, (int)floatMatrix2D.columns());
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                FloatMatrix2DTest.assertEquals((float)this.A.getQuick(nArray[i], nArray2[j]), (float)floatMatrix2D.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testViewSorted() {
        FloatMatrix2D floatMatrix2D = this.A.viewSorted(1);
        for (int i = 0; i < this.A.rows() - 1; ++i) {
            FloatMatrix2DTest.assertTrue((floatMatrix2D.getQuick(i + 1, 1) >= floatMatrix2D.getQuick(i, 1) ? 1 : 0) != 0);
        }
    }

    public void testViewStrides() {
        int n = 3;
        int n2 = 5;
        FloatMatrix2D floatMatrix2D = this.A.viewStrides(n, n2);
        for (int i = 0; i < floatMatrix2D.rows(); ++i) {
            for (int j = 0; j < floatMatrix2D.columns(); ++j) {
                FloatMatrix2DTest.assertEquals((float)this.A.getQuick(i * n, j * n2), (float)floatMatrix2D.getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testZMultFloatMatrix1DFloatMatrix1DFloatFloatBoolean() {
        int n;
        float f;
        int n2;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(this.A.columns());
        int n3 = 0;
        while ((long)n3 < denseFloatMatrix1D.size()) {
            ((FloatMatrix1D)denseFloatMatrix1D).setQuick(n3, (float)Math.random());
            ++n3;
        }
        float f2 = 3.0f;
        float f3 = 5.0f;
        FloatMatrix1D floatMatrix1D = FloatFactory1D.dense.random(this.A.rows());
        float[] fArray = floatMatrix1D.toArray();
        floatMatrix1D = this.A.zMult(denseFloatMatrix1D, floatMatrix1D, f2, f3, false);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            f = 0.0f;
            for (n = 0; n < this.A.columns(); ++n) {
                f += this.A.getQuick(n2, n) * ((FloatMatrix1D)denseFloatMatrix1D).getQuick(n);
            }
            fArray[n2] = f * f2 + fArray[n2] * f3;
        }
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            FloatMatrix2DTest.assertEquals((float)fArray[n2], (float)floatMatrix1D.getQuick(n2), (float)this.TOL);
        }
        floatMatrix1D = null;
        floatMatrix1D = this.A.zMult(denseFloatMatrix1D, floatMatrix1D, f2, f3, false);
        fArray = new float[this.A.rows()];
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            f = 0.0f;
            for (n = 0; n < this.A.columns(); ++n) {
                f += this.A.getQuick(n2, n) * ((FloatMatrix1D)denseFloatMatrix1D).getQuick(n);
            }
            fArray[n2] = f * f2;
        }
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            FloatMatrix2DTest.assertEquals((float)fArray[n2], (float)floatMatrix1D.getQuick(n2), (float)this.TOL);
        }
        denseFloatMatrix1D = new DenseFloatMatrix1D(this.A.rows());
        n2 = 0;
        while ((long)n2 < denseFloatMatrix1D.size()) {
            ((FloatMatrix1D)denseFloatMatrix1D).setQuick(n2, (float)Math.random());
            ++n2;
        }
        floatMatrix1D = FloatFactory1D.dense.random(this.A.columns());
        fArray = floatMatrix1D.toArray();
        floatMatrix1D = this.A.zMult(denseFloatMatrix1D, floatMatrix1D, f2, f3, true);
        for (n2 = 0; n2 < this.A.columns(); ++n2) {
            f = 0.0f;
            for (n = 0; n < this.A.rows(); ++n) {
                f += this.A.getQuick(n, n2) * ((FloatMatrix1D)denseFloatMatrix1D).getQuick(n);
            }
            fArray[n2] = f * f2 + fArray[n2] * f3;
        }
        for (n2 = 0; n2 < this.A.columns(); ++n2) {
            FloatMatrix2DTest.assertEquals((float)fArray[n2], (float)floatMatrix1D.getQuick(n2), (float)this.TOL);
        }
        floatMatrix1D = null;
        floatMatrix1D = this.A.zMult(denseFloatMatrix1D, floatMatrix1D, f2, f3, true);
        fArray = new float[this.A.columns()];
        for (n2 = 0; n2 < this.A.columns(); ++n2) {
            f = 0.0f;
            for (n = 0; n < this.A.rows(); ++n) {
                f += this.A.getQuick(n, n2) * ((FloatMatrix1D)denseFloatMatrix1D).getQuick(n);
            }
            fArray[n2] = f * f2;
        }
        for (n2 = 0; n2 < this.A.columns(); ++n2) {
            FloatMatrix2DTest.assertEquals((float)fArray[n2], (float)floatMatrix1D.getQuick(n2), (float)this.TOL);
        }
    }

    public void testZMultFloatMatrix2DFloatMatrix2DFloatFloatBooleanBoolean() {
        int n;
        float f;
        int n2;
        int n3;
        float f2 = 3.0f;
        float f3 = 5.0f;
        FloatMatrix2D floatMatrix2D = FloatFactory2D.dense.random(this.A.rows(), this.A.rows());
        float[][] fArray = floatMatrix2D.toArray();
        floatMatrix2D = this.A.zMult(this.Bt, floatMatrix2D, f2, f3, false, false);
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                f = 0.0f;
                for (n = 0; n < this.A.columns(); ++n) {
                    f += this.A.getQuick(n2, n) * this.Bt.getQuick(n, n3);
                }
                fArray[n2][n3] = f * f2 + fArray[n2][n3] * f3;
            }
        }
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                FloatMatrix2DTest.assertEquals((float)fArray[n3][n2], (float)floatMatrix2D.getQuick(n3, n2), (float)this.TOL);
            }
        }
        floatMatrix2D = null;
        floatMatrix2D = this.A.zMult(this.Bt, floatMatrix2D, f2, f3, false, false);
        fArray = new float[this.A.rows()][this.A.rows()];
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                f = 0.0f;
                for (n = 0; n < this.A.columns(); ++n) {
                    f += this.A.getQuick(n2, n) * this.Bt.getQuick(n, n3);
                }
                fArray[n2][n3] = f * f2;
            }
        }
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                FloatMatrix2DTest.assertEquals((float)fArray[n3][n2], (float)floatMatrix2D.getQuick(n3, n2), (float)this.TOL);
            }
        }
        floatMatrix2D = FloatFactory2D.dense.random(this.A.columns(), this.A.columns());
        fArray = floatMatrix2D.toArray();
        floatMatrix2D = this.A.zMult(this.B, floatMatrix2D, f2, f3, true, false);
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                f = 0.0f;
                for (n = 0; n < this.A.rows(); ++n) {
                    f += this.A.getQuick(n, n2) * this.B.getQuick(n, n3);
                }
                fArray[n2][n3] = f * f2 + fArray[n2][n3] * f3;
            }
        }
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                FloatMatrix2DTest.assertEquals((float)fArray[n3][n2], (float)floatMatrix2D.getQuick(n3, n2), (float)this.TOL);
            }
        }
        floatMatrix2D = null;
        floatMatrix2D = this.A.zMult(this.B, floatMatrix2D, f2, f3, true, false);
        fArray = new float[this.A.columns()][this.A.columns()];
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                f = 0.0f;
                for (n = 0; n < this.A.rows(); ++n) {
                    f += this.A.getQuick(n, n2) * this.B.getQuick(n, n3);
                }
                fArray[n2][n3] = f * f2;
            }
        }
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                FloatMatrix2DTest.assertEquals((float)fArray[n3][n2], (float)floatMatrix2D.getQuick(n3, n2), (float)this.TOL);
            }
        }
        floatMatrix2D = FloatFactory2D.dense.random(this.A.rows(), this.A.rows());
        fArray = floatMatrix2D.toArray();
        floatMatrix2D = this.A.zMult(this.B, floatMatrix2D, f2, f3, false, true);
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                f = 0.0f;
                for (n = 0; n < this.A.columns(); ++n) {
                    f += this.A.getQuick(n2, n) * this.B.getQuick(n3, n);
                }
                fArray[n2][n3] = f * f2 + fArray[n2][n3] * f3;
            }
        }
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                FloatMatrix2DTest.assertEquals((float)fArray[n3][n2], (float)floatMatrix2D.getQuick(n3, n2), (float)this.TOL);
            }
        }
        floatMatrix2D = null;
        floatMatrix2D = this.A.zMult(this.B, floatMatrix2D, f2, f3, false, true);
        fArray = new float[this.A.rows()][this.A.rows()];
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                f = 0.0f;
                for (n = 0; n < this.A.columns(); ++n) {
                    f += this.A.getQuick(n2, n) * this.B.getQuick(n3, n);
                }
                fArray[n2][n3] = f * f2;
            }
        }
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                FloatMatrix2DTest.assertEquals((float)fArray[n3][n2], (float)floatMatrix2D.getQuick(n3, n2), (float)this.TOL);
            }
        }
        floatMatrix2D = FloatFactory2D.dense.random(this.A.columns(), this.A.columns());
        fArray = floatMatrix2D.toArray();
        floatMatrix2D = this.A.zMult(this.Bt, floatMatrix2D, f2, f3, true, true);
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                f = 0.0f;
                for (n = 0; n < this.A.rows(); ++n) {
                    f += this.A.getQuick(n, n2) * this.Bt.getQuick(n3, n);
                }
                fArray[n2][n3] = f * f2 + fArray[n2][n3] * f3;
            }
        }
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                FloatMatrix2DTest.assertEquals((float)fArray[n3][n2], (float)floatMatrix2D.getQuick(n3, n2), (float)this.TOL);
            }
        }
        floatMatrix2D = null;
        floatMatrix2D = this.A.zMult(this.Bt, floatMatrix2D, f2, f3, true, true);
        fArray = new float[this.A.columns()][this.A.columns()];
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                f = 0.0f;
                for (n = 0; n < this.A.rows(); ++n) {
                    f += this.A.getQuick(n, n2) * this.Bt.getQuick(n3, n);
                }
                fArray[n2][n3] = f * f2;
            }
        }
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                FloatMatrix2DTest.assertEquals((float)fArray[n3][n2], (float)floatMatrix2D.getQuick(n3, n2), (float)this.TOL);
            }
        }
    }

    public void testZSum() {
        float f = this.A.zSum();
        float f2 = 0.0f;
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                f2 += this.A.getQuick(i, j);
            }
        }
        FloatMatrix2DTest.assertEquals((float)f2, (float)f, (float)this.TOL);
    }
}

