/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.IntIntFComplexFunction;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.algo.FComplexProperty;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.WrapperFComplexMatrix2D;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexFunctions;
import cern.jet.math.tfcomplex.FComplexMult;
import cern.jet.math.tfcomplex.FComplexPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DiagonalFComplexMatrix2D
extends WrapperFComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected float[] elements;
    protected int dlength;
    protected int dindex;

    public DiagonalFComplexMatrix2D(float[][] fArray, int n) {
        this(fArray.length, fArray.length == 0 ? 0 : fArray[0].length, n);
        this.assign(fArray);
    }

    public DiagonalFComplexMatrix2D(int n, int n2, int n3) {
        int n4;
        int n5;
        block3: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        if (n3 < -n + 1 || n3 > n2 - 1) {
            throw new IllegalArgumentException("index is out of bounds");
        }
        this.dindex = n3;
        this.dlength = n3 == 0 ? Math.min(n, n2) : (n3 > 0 ? (n >= n2 ? n2 - n3 : (n3 <= (n5 = n2 - n) ? n : n - (n3 - n5))) : (n >= n2 ? (-n3 <= (n4 = n - n2) ? n2 : n2 + n3 + n4) : n + n3));
        this.elements = new float[2 * this.dlength];
    }

    public FComplexMatrix2D assign(FComplexFComplexFunction fComplexFComplexFunction) {
        if (fComplexFComplexFunction instanceof FComplexMult) {
            float[] fArray = ((FComplexMult)fComplexFComplexFunction).multiplicator;
            if (fArray[0] == 1.0f && fArray[1] == 0.0f) {
                return this;
            }
            if (fArray[0] == 0.0f && fArray[1] == 0.0f) {
                return this.assign(fArray);
            }
            if (fArray[0] != fArray[0] || fArray[1] != fArray[1]) {
                return this.assign(fArray);
            }
            float[] fArray2 = new float[2];
            for (int i = 0; i < this.dlength; ++i) {
                fArray2[0] = this.elements[2 * i];
                fArray2[1] = this.elements[2 * i + 1];
                fArray2 = FComplex.mult(fArray2, fArray);
                this.elements[2 * i] = fArray2[0];
                this.elements[2 * i + 1] = fArray2[1];
            }
        } else {
            float[] fArray = new float[2];
            for (int i = 0; i < this.dlength; ++i) {
                fArray[0] = this.elements[2 * i];
                fArray[1] = this.elements[2 * i + 1];
                fArray = fComplexFComplexFunction.apply(fArray);
                this.elements[2 * i] = fArray[0];
                this.elements[2 * i + 1] = fArray[1];
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(float f, float f2) {
        for (int i = 0; i < this.dlength; ++i) {
            this.elements[2 * i] = f;
            this.elements[2 * i + 1] = f2;
        }
        return this;
    }

    public FComplexMatrix2D assign(final float[] fArray) {
        if (fArray.length != 2 * this.dlength) {
            throw new IllegalArgumentException("Must have same length: length=" + fArray.length + " 2*dlength=" + 2 * this.dlength);
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.dlength);
            Future[] futureArray = new Future[n];
            int n2 = this.dlength / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.dlength : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DiagonalFComplexMatrix2D.this.elements[2 * i] = fArray[2 * i];
                            DiagonalFComplexMatrix2D.this.elements[2 * i + 1] = fArray[2 * i + 1];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.dlength; ++i) {
                this.elements[2 * i] = fArray[2 * i];
                this.elements[2 * i + 1] = fArray[2 * i + 1];
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(float[][] fArray) {
        int n;
        int n2;
        if (fArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + fArray.length + "rows()=" + this.rows());
        }
        if (this.dindex >= 0) {
            n2 = 0;
            n = this.dindex;
        } else {
            n2 = -this.dindex;
            n = 0;
        }
        for (int i = 0; i < this.dlength; ++i) {
            if (fArray[i].length != 2 * this.columns) {
                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray[n2].length + "2 * columns()=" + 2 * this.columns());
            }
            this.elements[2 * i] = fArray[n2][2 * n];
            this.elements[2 * i + 1] = fArray[n2][2 * n + 1];
            ++n;
            ++n2;
        }
        return this;
    }

    public FComplexMatrix2D assign(FComplexMatrix2D fComplexMatrix2D) {
        if (fComplexMatrix2D == this) {
            return this;
        }
        this.checkShape(fComplexMatrix2D);
        if (fComplexMatrix2D instanceof DiagonalFComplexMatrix2D) {
            DiagonalFComplexMatrix2D diagonalFComplexMatrix2D = (DiagonalFComplexMatrix2D)fComplexMatrix2D;
            if (this.dindex != diagonalFComplexMatrix2D.dindex || this.dlength != diagonalFComplexMatrix2D.dlength) {
                throw new IllegalArgumentException("source is DiagonalFComplexMatrix2D with different diagonal stored.");
            }
            System.arraycopy(diagonalFComplexMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        return super.assign(fComplexMatrix2D);
    }

    public FComplexMatrix2D assign(FComplexMatrix2D fComplexMatrix2D, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction) {
        this.checkShape(fComplexMatrix2D);
        if (fComplexMatrix2D instanceof DiagonalFComplexMatrix2D) {
            float[] fArray;
            DiagonalFComplexMatrix2D diagonalFComplexMatrix2D = (DiagonalFComplexMatrix2D)fComplexMatrix2D;
            if (this.dindex != diagonalFComplexMatrix2D.dindex || this.dlength != diagonalFComplexMatrix2D.dlength) {
                throw new IllegalArgumentException("y is DiagonalFComplexMatrix2D with different diagonal stored.");
            }
            if (fComplexFComplexFComplexFunction instanceof FComplexPlusMultSecond && (fArray = ((FComplexPlusMultSecond)fComplexFComplexFComplexFunction).multiplicator)[0] == 0.0f && fArray[1] == 0.0f) {
                return this;
            }
            fArray = diagonalFComplexMatrix2D.elements;
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.dlength);
                Future[] futureArray = new Future[n];
                int n2 = this.dlength / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.dlength : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            if (fComplexFComplexFComplexFunction instanceof FComplexPlusMultSecond) {
                                float[] fArray6 = ((FComplexPlusMultSecond)fComplexFComplexFComplexFunction).multiplicator;
                                if (fArray6[0] == 1.0f && fArray6[1] == 0.0f) {
                                    for (int i = n3; i < n4; ++i) {
                                        int n = 2 * i;
                                        DiagonalFComplexMatrix2D.this.elements[n] = DiagonalFComplexMatrix2D.this.elements[n] + fArray[2 * i];
                                        int n2 = 2 * i + 1;
                                        DiagonalFComplexMatrix2D.this.elements[n2] = DiagonalFComplexMatrix2D.this.elements[n2] + fArray[2 * i + 1];
                                    }
                                } else {
                                    float[] fArray2 = new float[2];
                                    for (int i = n3; i < n4; ++i) {
                                        fArray2[0] = fArray[2 * i];
                                        fArray2[1] = fArray[2 * i + 1];
                                        fArray2 = FComplex.mult(fArray6, fArray2);
                                        int n = 2 * i;
                                        DiagonalFComplexMatrix2D.this.elements[n] = DiagonalFComplexMatrix2D.this.elements[n] + fArray2[0];
                                        int n32 = 2 * i + 1;
                                        DiagonalFComplexMatrix2D.this.elements[n32] = DiagonalFComplexMatrix2D.this.elements[n32] + fArray2[1];
                                    }
                                }
                            } else if (fComplexFComplexFComplexFunction == FComplexFunctions.mult) {
                                float[] fArray7 = new float[2];
                                float[] fArray3 = new float[2];
                                for (int i = n3; i < n4; ++i) {
                                    fArray3[0] = fArray[2 * i];
                                    fArray3[1] = fArray[2 * i + 1];
                                    fArray7[0] = DiagonalFComplexMatrix2D.this.elements[2 * i];
                                    fArray7[1] = DiagonalFComplexMatrix2D.this.elements[2 * i + 1];
                                    fArray7 = FComplex.mult(fArray7, fArray3);
                                    DiagonalFComplexMatrix2D.this.elements[2 * i] = fArray7[0];
                                    DiagonalFComplexMatrix2D.this.elements[2 * i + 1] = fArray7[1];
                                }
                            } else if (fComplexFComplexFComplexFunction == FComplexFunctions.div) {
                                float[] fArray8 = new float[2];
                                float[] fArray4 = new float[2];
                                for (int i = n3; i < n4; ++i) {
                                    fArray4[0] = fArray[2 * i];
                                    fArray4[1] = fArray[2 * i + 1];
                                    fArray8[0] = DiagonalFComplexMatrix2D.this.elements[2 * i];
                                    fArray8[1] = DiagonalFComplexMatrix2D.this.elements[2 * i + 1];
                                    fArray8 = FComplex.div(fArray8, fArray4);
                                    DiagonalFComplexMatrix2D.this.elements[2 * i] = fArray8[0];
                                    DiagonalFComplexMatrix2D.this.elements[2 * i + 1] = fArray8[1];
                                }
                            } else {
                                float[] fArray9 = new float[2];
                                float[] fArray5 = new float[2];
                                for (int i = n3; i < n4; ++i) {
                                    fArray5[0] = fArray[2 * i];
                                    fArray5[1] = fArray[2 * i + 1];
                                    fArray9[0] = DiagonalFComplexMatrix2D.this.elements[2 * i];
                                    fArray9[1] = DiagonalFComplexMatrix2D.this.elements[2 * i + 1];
                                    fArray9 = fComplexFComplexFComplexFunction.apply(fArray9, fArray5);
                                    DiagonalFComplexMatrix2D.this.elements[2 * i] = fArray9[0];
                                    DiagonalFComplexMatrix2D.this.elements[2 * i + 1] = fArray9[1];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else if (fComplexFComplexFComplexFunction instanceof FComplexPlusMultSecond) {
                float[] fArray2 = ((FComplexPlusMultSecond)fComplexFComplexFComplexFunction).multiplicator;
                if (fArray2[0] == 1.0f && fArray2[1] == 0.0f) {
                    for (int i = 0; i < this.dlength; ++i) {
                        int n5 = 2 * i;
                        this.elements[n5] = this.elements[n5] + fArray[2 * i];
                        int n6 = 2 * i + 1;
                        this.elements[n6] = this.elements[n6] + fArray[2 * i + 1];
                    }
                } else {
                    float[] fArray3 = new float[2];
                    for (int i = 0; i < this.dlength; ++i) {
                        fArray3[0] = fArray[2 * i];
                        fArray3[1] = fArray[2 * i + 1];
                        fArray3 = FComplex.mult(fArray2, fArray3);
                        int n7 = 2 * i;
                        this.elements[n7] = this.elements[n7] + fArray3[0];
                        int n8 = 2 * i + 1;
                        this.elements[n8] = this.elements[n8] + fArray3[1];
                    }
                }
            } else if (fComplexFComplexFComplexFunction == FComplexFunctions.mult) {
                float[] fArray4 = new float[2];
                float[] fArray5 = new float[2];
                for (int i = 0; i < this.dlength; ++i) {
                    fArray5[0] = fArray[2 * i];
                    fArray5[1] = fArray[2 * i + 1];
                    fArray4[0] = this.elements[2 * i];
                    fArray4[1] = this.elements[2 * i + 1];
                    fArray4 = FComplex.mult(fArray4, fArray5);
                    this.elements[2 * i] = fArray4[0];
                    this.elements[2 * i + 1] = fArray4[1];
                }
            } else if (fComplexFComplexFComplexFunction == FComplexFunctions.div) {
                float[] fArray6 = new float[2];
                float[] fArray7 = new float[2];
                for (int i = 0; i < this.dlength; ++i) {
                    fArray7[0] = fArray[2 * i];
                    fArray7[1] = fArray[2 * i + 1];
                    fArray6[0] = this.elements[2 * i];
                    fArray6[1] = this.elements[2 * i + 1];
                    fArray6 = FComplex.div(fArray6, fArray7);
                    this.elements[2 * i] = fArray6[0];
                    this.elements[2 * i + 1] = fArray6[1];
                }
            } else {
                float[] fArray8 = new float[2];
                float[] fArray9 = new float[2];
                for (int i = 0; i < this.dlength; ++i) {
                    fArray9[0] = fArray[2 * i];
                    fArray9[1] = fArray[2 * i + 1];
                    fArray8[0] = this.elements[2 * i];
                    fArray8[1] = this.elements[2 * i + 1];
                    fArray8 = fComplexFComplexFComplexFunction.apply(fArray8, fArray9);
                    this.elements[2 * i] = fArray8[0];
                    this.elements[2 * i + 1] = fArray8[1];
                }
            }
            return this;
        }
        return super.assign(fComplexMatrix2D, fComplexFComplexFComplexFunction);
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            n2 = Math.min(n2, this.dlength);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.dlength / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.dlength : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            if (DiagonalFComplexMatrix2D.this.elements[2 * i] == 0.0f && DiagonalFComplexMatrix2D.this.elements[2 * i + 1] == 0.0f) continue;
                            ++n;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.dlength; ++i) {
                if (this.elements[2 * i] == 0.0f && this.elements[2 * i + 1] == 0.0f) continue;
                ++n;
            }
        }
        return n;
    }

    public float[] elements() {
        return this.elements;
    }

    public boolean equals(float[] fArray) {
        float f = FComplexProperty.DEFAULT.tolerance();
        float[] fArray2 = new float[2];
        float[] fArray3 = new float[2];
        for (int i = 0; i < this.dlength; ++i) {
            fArray2[0] = this.elements[2 * i];
            fArray2[1] = this.elements[2 * i + 1];
            fArray3[0] = Math.abs(fArray[0] - fArray2[0]);
            fArray3[1] = Math.abs(fArray[1] - fArray2[1]);
            if (!((fArray3[0] == fArray3[0] && fArray3[1] == fArray3[1] || fArray[0] == fArray[0] && fArray[1] == fArray[1] || fArray2[0] == fArray2[0] && fArray2[1] == fArray2[1]) && !FComplex.isEqual(fArray, fArray2, f))) {
                fArray3[0] = 0.0f;
                fArray3[1] = 0.0f;
            }
            if (!(fArray3[0] > f) && !(fArray3[1] > f)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof DiagonalFComplexMatrix2D) {
            DiagonalFComplexMatrix2D diagonalFComplexMatrix2D = (DiagonalFComplexMatrix2D)object;
            float f = FComplexProperty.DEFAULT.tolerance();
            if (this == object) {
                return true;
            }
            if (this == null || object == null) {
                return false;
            }
            int n = this.rows();
            int n2 = this.columns();
            if (n2 != diagonalFComplexMatrix2D.columns() || n != diagonalFComplexMatrix2D.rows()) {
                return false;
            }
            if (this.dindex != diagonalFComplexMatrix2D.dindex || this.dlength != diagonalFComplexMatrix2D.dlength) {
                return false;
            }
            float[] fArray = diagonalFComplexMatrix2D.elements;
            float[] fArray2 = new float[2];
            float[] fArray3 = new float[2];
            float[] fArray4 = new float[2];
            for (int i = 0; i < this.dlength; ++i) {
                fArray2[0] = this.elements[2 * i];
                fArray2[1] = this.elements[2 * i + 1];
                fArray3[0] = fArray[2 * i];
                fArray3[1] = fArray[2 * i + 1];
                fArray4[0] = Math.abs(fArray3[0] - fArray2[0]);
                fArray4[1] = Math.abs(fArray3[1] - fArray2[1]);
                if (!((fArray4[0] == fArray4[0] && fArray4[1] == fArray4[1] || fArray3[0] == fArray3[0] && fArray3[1] == fArray3[1] || fArray2[0] == fArray2[0] && fArray2[1] == fArray2[1]) && !FComplex.isEqual(fArray3, fArray2, f))) {
                    fArray4[0] = 0.0f;
                    fArray4[1] = 0.0f;
                }
                if (!(fArray4[0] > f) && !(fArray4[1] > f)) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    public FComplexMatrix2D forEachNonZero(IntIntFComplexFunction intIntFComplexFunction) {
        float[] fArray = new float[2];
        for (int i = 0; i < this.dlength; ++i) {
            fArray[0] = this.elements[2 * i];
            fArray[1] = this.elements[2 * i + 1];
            if (fArray[0] == 0.0f && fArray[1] == 0.0f) continue;
            fArray = intIntFComplexFunction.apply(i, i, fArray);
            this.elements[2 * i] = fArray[0];
            this.elements[2 * i + 1] = fArray[1];
        }
        return this;
    }

    public int diagonalLength() {
        return this.dlength;
    }

    public int diagonalIndex() {
        return this.dindex;
    }

    public float[] getQuick(int n, int n2) {
        if (this.dindex >= 0) {
            if (n2 < this.dindex) {
                return new float[2];
            }
            if (n < this.dlength && n + this.dindex == n2) {
                return new float[]{this.elements[2 * n], this.elements[2 * n + 1]};
            }
            return new float[2];
        }
        if (n < -this.dindex) {
            return new float[2];
        }
        if (n2 < this.dlength && n + this.dindex == n2) {
            return new float[]{this.elements[2 * n2], this.elements[2 * n2 + 1]};
        }
        return new float[2];
    }

    public FComplexMatrix2D like(int n, int n2) {
        return new SparseFComplexMatrix2D(n, n2);
    }

    public FComplexMatrix1D like1D(int n) {
        return new SparseFComplexMatrix1D(n);
    }

    public void setQuick(int n, int n2, float[] fArray) {
        if (this.dindex >= 0) {
            if (n2 >= this.dindex && n < this.dlength && n + this.dindex == n2) {
                this.elements[2 * n] = fArray[0];
                this.elements[2 * n + 1] = fArray[1];
            }
        } else if (n >= -this.dindex && n2 < this.dlength && n + this.dindex == n2) {
            this.elements[2 * n2] = fArray[0];
            this.elements[2 * n2 + 1] = fArray[1];
        }
    }

    public void setQuick(int n, int n2, float f, float f2) {
        if (this.dindex >= 0) {
            if (n2 >= this.dindex && n < this.dlength && n + this.dindex == n2) {
                this.elements[2 * n] = f;
                this.elements[2 * n + 1] = f2;
            }
        } else if (n >= -this.dindex && n2 < this.dlength && n + this.dindex == n2) {
            this.elements[2 * n2] = f;
            this.elements[2 * n2 + 1] = f2;
        }
    }

    public FComplexMatrix1D zMult(FComplexMatrix1D fComplexMatrix1D, FComplexMatrix1D fComplexMatrix1D2, float[] fArray, float[] fArray2, boolean bl) {
        boolean bl2;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        boolean bl3 = bl2 = fComplexMatrix1D2 == null;
        if (fComplexMatrix1D2 == null) {
            fComplexMatrix1D2 = new DenseFComplexMatrix1D(n);
        }
        if (!(this.isNoView && fComplexMatrix1D instanceof DenseFComplexMatrix1D && fComplexMatrix1D2 instanceof DenseFComplexMatrix1D)) {
            return super.zMult(fComplexMatrix1D, fComplexMatrix1D2, fArray, fArray2, bl);
        }
        if ((long)n2 != fComplexMatrix1D.size() || (long)n > fComplexMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + fComplexMatrix1D.toStringShort() + ", " + fComplexMatrix1D2.toStringShort());
        }
        if (!(bl2 || fArray2[0] == 1.0f && fArray2[1] == 0.0f)) {
            fComplexMatrix1D2.assign(FComplexFunctions.mult(fArray2));
        }
        DenseFComplexMatrix1D denseFComplexMatrix1D = (DenseFComplexMatrix1D)fComplexMatrix1D2;
        float[] fArray3 = denseFComplexMatrix1D.elements;
        int n3 = denseFComplexMatrix1D.stride();
        int n4 = (int)fComplexMatrix1D2.index(0);
        DenseFComplexMatrix1D denseFComplexMatrix1D2 = (DenseFComplexMatrix1D)fComplexMatrix1D;
        float[] fArray4 = denseFComplexMatrix1D2.elements;
        int n5 = denseFComplexMatrix1D2.stride();
        int n6 = (int)fComplexMatrix1D.index(0);
        if (fArray4 == null || fArray3 == null) {
            throw new InternalError();
        }
        float[] fArray5 = new float[2];
        float[] fArray6 = new float[2];
        if (!bl) {
            if (this.dindex >= 0) {
                for (int i = 0; i < this.dlength; ++i) {
                    fArray5[0] = this.elements[2 * i];
                    fArray5[1] = this.elements[2 * i + 1];
                    fArray6[0] = fArray4[2 * this.dindex + n6 + n5 * i];
                    fArray6[1] = fArray4[2 * this.dindex + n6 + n5 * i + 1];
                    fArray5 = FComplex.mult(fArray5, fArray6);
                    fArray5 = FComplex.mult(fArray, fArray5);
                    int n7 = n4 + n3 * i;
                    fArray3[n7] = fArray3[n7] + fArray5[0];
                    int n8 = n4 + n3 * i + 1;
                    fArray3[n8] = fArray3[n8] + fArray5[1];
                }
            } else {
                for (int i = 0; i < this.dlength; ++i) {
                    fArray5[0] = this.elements[2 * i];
                    fArray5[1] = this.elements[2 * i + 1];
                    fArray6[0] = fArray4[n6 + n5 * i];
                    fArray6[1] = fArray4[n6 + n5 * i + 1];
                    fArray5 = FComplex.mult(fArray5, fArray6);
                    fArray5 = FComplex.mult(fArray, fArray5);
                    int n9 = -2 * this.dindex + n4 + n3 * i;
                    fArray3[n9] = fArray3[n9] + fArray5[0];
                    int n10 = -2 * this.dindex + n4 + n3 * i + 1;
                    fArray3[n10] = fArray3[n10] + fArray5[1];
                }
            }
        } else if (this.dindex >= 0) {
            for (int i = 0; i < this.dlength; ++i) {
                fArray5[0] = this.elements[2 * i];
                fArray5[1] = -this.elements[2 * i + 1];
                fArray6[0] = fArray4[n6 + n5 * i];
                fArray6[1] = fArray4[n6 + n5 * i + 1];
                fArray5 = FComplex.mult(fArray5, fArray6);
                fArray5 = FComplex.mult(fArray, fArray5);
                int n11 = 2 * this.dindex + n4 + n3 * i;
                fArray3[n11] = fArray3[n11] + fArray5[0];
                int n12 = 2 * this.dindex + n4 + n3 * i + 1;
                fArray3[n12] = fArray3[n12] + fArray5[1];
            }
        } else {
            for (int i = 0; i < this.dlength; ++i) {
                fArray5[0] = this.elements[2 * i];
                fArray5[1] = -this.elements[2 * i + 1];
                fArray6[0] = fArray4[-2 * this.dindex + n6 + n5 * i];
                fArray6[1] = fArray4[-2 * this.dindex + n6 + n5 * i + 1];
                fArray5 = FComplex.mult(fArray5, fArray6);
                fArray5 = FComplex.mult(fArray, fArray5);
                int n13 = n4 + n3 * i;
                fArray3[n13] = fArray3[n13] + fArray5[0];
                int n14 = n4 + n3 * i + 1;
                fArray3[n14] = fArray3[n14] + fArray5[1];
            }
        }
        return fComplexMatrix1D2;
    }

    protected FComplexMatrix2D getContent() {
        return this;
    }
}

