/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simevents;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import umontreal.iro.lecuyer.simevents.Accumulate;
import umontreal.iro.lecuyer.simevents.Simulator;
import umontreal.iro.lecuyer.stat.Tally;
import umontreal.iro.lecuyer.util.PrintfFormat;
import umontreal.iro.lecuyer.util.TransformingList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListWithStat<E>
extends TransformingList<E, Node<E>> {
    private boolean stats;
    private double initTime;
    private Accumulate blockSize;
    private Tally blockSojourn;
    private String name;
    private Simulator sim;

    public ListWithStat(List<Node<E>> nodeList) {
        super(nodeList);
        nodeList.clear();
        this.sim = Simulator.getDefaultSimulator();
        this.stats = false;
    }

    public ListWithStat(Simulator inSim, List<Node<E>> nodeList) {
        super(nodeList);
        if (inSim == null || nodeList == null) {
            throw new NullPointerException();
        }
        nodeList.clear();
        this.sim = inSim;
        this.stats = false;
    }

    public ListWithStat(List<Node<E>> nodeList, Collection<? extends E> c) {
        this(Simulator.getDefaultSimulator(), nodeList);
        this.addAll(c);
    }

    public ListWithStat(Simulator inSim, List<Node<E>> nodeList, Collection<? extends E> c) {
        this(inSim, nodeList);
        this.addAll(c);
    }

    public ListWithStat(List<Node<E>> nodeList, String name) {
        this(Simulator.getDefaultSimulator(), nodeList);
        this.name = name;
    }

    public ListWithStat(Simulator inSim, List<Node<E>> nodeList, String name) {
        this(inSim, nodeList);
        this.name = name;
    }

    public ListWithStat(List<Node<E>> nodeList, Collection<? extends E> c, String name) {
        this(Simulator.getDefaultSimulator(), nodeList);
        this.name = name;
        this.addAll(c);
    }

    public ListWithStat(Simulator inSim, List<Node<E>> nodeList, Collection<? extends E> c, String name) {
        this(inSim, nodeList);
        this.name = name;
        this.addAll(c);
    }

    @Override
    public E convertFromInnerType(Node<E> node) {
        return node.getElement();
    }

    @Override
    public Node<E> convertToInnerType(E element) {
        return new Node<E>(element, this.sim.time());
    }

    public Simulator simulator() {
        return this.sim;
    }

    public void setSimulator(Simulator sim) {
        if (sim == null) {
            throw new NullPointerException();
        }
        this.sim = sim;
        if (this.blockSize != null) {
            this.blockSize.setSimulator(sim);
        }
    }

    @Override
    public void clear() {
        if (this.stats) {
            this.initStat();
        }
        super.clear();
    }

    @Override
    public void add(int index, E obj) {
        super.add(index, obj);
        if (this.stats) {
            this.blockSize.update(this.size());
        }
    }

    @Override
    public E remove(int index) {
        Node node = (Node)this.getInnerList().get(index);
        if (this.stats) {
            this.blockSojourn.add(this.sim.time() - node.getInsertionTime());
        }
        Object e = super.remove(index);
        if (this.stats) {
            this.blockSize.update(this.size());
        }
        return (E)e;
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorWithStat(this.getInnerList().iterator());
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListIteratorWithStat(this.getInnerList().listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ListIteratorWithStat(this.getInnerList().listIterator(index));
    }

    @Override
    public E set(int index, E element) {
        Node oldNode = (Node)this.getInnerList().get(index);
        Object oldElement = oldNode.getElement();
        boolean equal = oldElement == null || element == null ? oldElement == element : oldElement.equals(element);
        if (equal) {
            this.getInnerList().set(index, new Node<E>(element, oldNode.getInsertionTime()));
            return oldElement;
        }
        if (this.stats) {
            this.blockSojourn.add(this.sim.time() - oldNode.getInsertionTime());
        }
        this.getInnerList().set(index, new Node<E>(element, this.sim.time()));
        return oldElement;
    }

    public boolean getStatCollecting() {
        return this.stats;
    }

    public void setStatCollecting(boolean b) {
        if (b && !this.stats) {
            if (this.blockSize == null) {
                this.blockSize = new Accumulate(this.sim, "List Size " + this.name);
            }
            if (this.blockSojourn == null) {
                this.blockSojourn = new Tally("List Sojourn " + this.name);
            }
            this.blockSize.update(this.size());
            this.stats = true;
            this.initStat();
        } else {
            this.stats = false;
        }
    }

    public void initStat() {
        if (!this.stats) {
            throw new IllegalStateException("initStat for a list that did not call setStatCollecting (true).");
        }
        this.blockSize.init();
        this.blockSojourn.init();
        this.blockSize.update(this.size());
        this.initTime = this.sim.time();
    }

    public double getInitTime() {
        return this.initTime;
    }

    public Accumulate statSize() {
        return this.blockSize;
    }

    public Tally statSojourn() {
        return this.blockSojourn;
    }

    public String report() {
        if (this.blockSojourn == null || this.blockSize == null) {
            throw new IllegalStateException("Calling report when no statistics were collected");
        }
        PrintfFormat str = new PrintfFormat();
        str.append(PrintfFormat.NEWLINE + "REPORT ON LIST : ").append(this.name).append(PrintfFormat.NEWLINE);
        str.append("   From time: ").append(7, 2, 2, this.initTime);
        str.append(" to time: ").append(10, 2, 2, this.sim.time());
        str.append("                  min        max      average  ");
        str.append("standard dev.  nb. Obs");
        str.append("   Size    ");
        str.append(9, (int)(this.blockSize.min() + 0.5));
        str.append(11, (int)(this.blockSize.max() + 0.5));
        str.append(14, 3, 2, this.blockSize.average()).append(PrintfFormat.NEWLINE);
        str.append("   Sojourn ");
        str.append(12, 3, 2, this.blockSojourn.min()).append(" ");
        str.append(10, 3, 2, this.blockSojourn.max()).append(" ");
        str.append(10, 3, 2, this.blockSojourn.average()).append(" ");
        str.append(10, 3, 2, this.blockSojourn.standardDeviation()).append(" ");
        str.append(11, this.blockSojourn.numberObs()).append(PrintfFormat.NEWLINE);
        return str.toString();
    }

    public String getName() {
        return this.name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node<E> {
        private E element;
        private double insertionTime;

        public Node(E element, double insertionTime) {
            this.element = element;
            this.insertionTime = insertionTime;
        }

        public E getElement() {
            return this.element;
        }

        public double getInsertionTime() {
            return this.insertionTime;
        }

        public String toString() {
            String str = this.element == null ? "null" : this.element.toString();
            str = str + " (inserted at time " + this.insertionTime + ")";
            return str;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListIteratorWithStat
    implements ListIterator<E> {
        private ListIterator<Node<E>> itr;
        private Node<E> lastRet;

        public ListIteratorWithStat(ListIterator<Node<E>> itr) {
            this.itr = itr;
        }

        @Override
        public void add(E o) {
            this.itr.add(new Node(o, ListWithStat.this.sim.time()));
            this.lastRet = null;
            if (ListWithStat.this.stats) {
                ListWithStat.this.blockSize.update(ListWithStat.this.size());
            }
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.itr.hasPrevious();
        }

        @Override
        public E next() {
            this.lastRet = this.itr.next();
            return this.lastRet.getElement();
        }

        @Override
        public int nextIndex() {
            return this.itr.nextIndex();
        }

        @Override
        public E previous() {
            this.lastRet = this.itr.previous();
            return this.lastRet.getElement();
        }

        @Override
        public int previousIndex() {
            return this.itr.previousIndex();
        }

        @Override
        public void remove() {
            this.itr.remove();
            if (ListWithStat.this.stats) {
                ListWithStat.this.blockSize.update(ListWithStat.this.size());
                ListWithStat.this.blockSojourn.add(ListWithStat.this.sim.time() - this.lastRet.getInsertionTime());
            }
            this.lastRet = null;
        }

        @Override
        public void set(E element) {
            if (this.lastRet == null) {
                throw new NoSuchElementException();
            }
            Node oldNode = this.lastRet;
            Object oldElement = oldNode.getElement();
            boolean equal = oldElement == null || element == null ? oldElement == element : oldElement.equals(element);
            if (equal) {
                this.lastRet = new Node(element, oldNode.getInsertionTime());
                this.itr.set(this.lastRet);
            } else {
                if (ListWithStat.this.stats) {
                    ListWithStat.this.blockSojourn.add(ListWithStat.this.sim.time() - oldNode.getInsertionTime());
                }
                this.lastRet = new Node(element, ListWithStat.this.sim.time());
                this.itr.set(this.lastRet);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IteratorWithStat
    implements Iterator<E> {
        private Iterator<Node<E>> itr;
        private Node<E> lastRet;

        public IteratorWithStat(Iterator<Node<E>> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public E next() {
            this.lastRet = this.itr.next();
            return this.lastRet.getElement();
        }

        @Override
        public void remove() {
            this.itr.remove();
            if (ListWithStat.this.stats) {
                ListWithStat.this.blockSize.update(ListWithStat.this.size());
                ListWithStat.this.blockSojourn.add(ListWithStat.this.sim.time() - this.lastRet.getInsertionTime());
            }
            this.lastRet = null;
        }
    }
}

