/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.util.PrintfFormat;

class F2wPoly {
    private int r;
    private F2w.F2wElem[] coeff;
    private int[] noCoeff;
    private F2w f2wBase;
    private F2wPolyElem[] z_i;

    public F2wPoly(int r, F2w.F2wElem[] coeff, int[] noCoeff, F2w f2wBase) {
        int i;
        this.r = r;
        this.coeff = new F2w.F2wElem[coeff.length];
        this.noCoeff = new int[noCoeff.length];
        for (i = 0; i < coeff.length; ++i) {
            this.coeff[i] = coeff[i];
            this.noCoeff[i] = noCoeff[i];
        }
        this.f2wBase = f2wBase;
        this.z_i = new F2wPolyElem[2 * r];
        this.z_i[0] = new F2wPolyElem();
        for (i = 0; i < r; ++i) {
            this.z_i[0].value[i].value = 0;
        }
        this.z_i[0].value[0].value = Integer.MIN_VALUE;
        for (i = 1; i < 2 * r; ++i) {
            this.z_i[i] = this.z_i[i - 1].multiplyZ();
        }
    }

    public F2wPolyElem createElem() {
        return new F2wPolyElem();
    }

    public F2wPolyElem createElem(F2wPolyElem that) {
        return new F2wPolyElem(that);
    }

    public F2wPolyElem createElem(int[] value) {
        return new F2wPolyElem(value);
    }

    public F2wPolyElem createZ() {
        int[] val = new int[this.r];
        for (int i = 0; i < this.r; ++i) {
            val[i] = 0;
        }
        val[1] = Integer.MIN_VALUE;
        return this.createElem(val);
    }

    public static void main(String[] args) {
        F2w f1 = new F2w(32, 65538);
        F2w f2 = new F2w(32, 270549120);
        F2w.F2wElem e1 = f1.createElem(305419896);
        F2w.F2wElem e2 = f2.createElem(0x19414111);
        F2w.F2wElem e3 = e1.multiply(e2);
    }

    public class F2wPolyElem {
        private F2w.F2wElem[] value;

        private F2wPolyElem() {
            this.value = new F2w.F2wElem[F2wPoly.this.r];
            for (int i = 0; i < F2wPoly.this.r; ++i) {
                this.value[i] = F2wPoly.this.f2wBase.createElem();
            }
        }

        private F2wPolyElem(F2wPolyElem that) {
            if (this.getBase() != that.getBase()) {
                throw new IllegalArgumentException("The copied F2wPolyElem must come from the same F2wPoly.");
            }
            this.value = new F2w.F2wElem[F2wPoly.this.r];
            for (int i = 0; i < F2wPoly.this.r; ++i) {
                this.value[i] = F2wPoly.this.f2wBase.createElem(that.value[i]);
            }
        }

        private F2wPolyElem(int[] value) {
            if (F2wPoly.this.r != value.length) {
                throw new IllegalArgumentException("Array length must be equal to r (" + F2wPoly.this.r + ")");
            }
            this.value = new F2w.F2wElem[F2wPoly.this.r];
            for (int i = 0; i < F2wPoly.this.r; ++i) {
                this.value[i] = F2wPoly.this.f2wBase.createElem(value[i]);
            }
        }

        public F2wPoly getBase() {
            return F2wPoly.this;
        }

        public F2wPolyElem multiplyZ() {
            int i;
            F2wPolyElem res = new F2wPolyElem();
            res.value[0].value = 0;
            for (i = 1; i < F2wPoly.this.r; ++i) {
                res.value[i].value = this.value[i - 1].value;
            }
            for (i = 0; i < F2wPoly.this.noCoeff.length; ++i) {
                res.value[F2wPoly.this.noCoeff[i]].value ^= this.value[F2wPoly.this.r - 1].multiply(F2wPoly.this.coeff[i]).value;
            }
            return res;
        }

        public F2wPolyElem multiply(F2wPolyElem that) {
            if (this.getBase() != that.getBase()) {
                throw new IllegalArgumentException("Both F2wPolyElem must originate from the same F2wPoly.");
            }
            F2wPolyElem res = new F2wPolyElem();
            for (int i = 0; i < F2wPoly.this.r; ++i) {
                for (int j = 0; j < F2wPoly.this.r; ++j) {
                    F2w.F2wElem temp = this.value[i].multiply(that.value[j]);
                    for (int k = 0; k < F2wPoly.this.r; ++k) {
                        res.value[k].value ^= ((F2wPoly)F2wPoly.this).z_i[i + j].value[k].multiply(temp).value;
                    }
                }
            }
            return res;
        }

        public F2wPolyElem exponentiateBase2(int d) {
            F2wPolyElem res = new F2wPolyElem(this);
            F2wPolyElem temp = new F2wPolyElem();
            for (int i = 0; i < d; ++i) {
                int j;
                for (j = 0; j < F2wPoly.this.r; ++j) {
                    temp.value[j].value = 0;
                }
                for (j = 0; j < F2wPoly.this.r; ++j) {
                    F2w.F2wElem coeff = res.value[j].square();
                    for (int k = 0; k < F2wPoly.this.r; ++k) {
                        temp.value[k].value ^= ((F2wPoly)F2wPoly.this).z_i[2 * j].value[k].multiply(coeff).value;
                    }
                }
                for (j = 0; j < F2wPoly.this.r; ++j) {
                    res.value[j].value = temp.value[j].value;
                }
            }
            return res;
        }

        public void copyFrom(F2wPolyElem that) {
            if (this.getBase() != that.getBase()) {
                throw new IllegalArgumentException("Both F2wPolyElem must originate from the same F2wPoly.");
            }
            for (int i = 0; i < F2wPoly.this.r; ++i) {
                this.value[i].value = that.value[i].value;
            }
        }

        public void copyFrom(int[] val) {
            if (F2wPoly.this.r != this.value.length) {
                throw new IllegalArgumentException("Array length must be equal to r (" + F2wPoly.this.r + ")");
            }
            for (int i = 0; i < F2wPoly.this.r; ++i) {
                this.value[i].value = val[i];
            }
        }

        public void copyTo(int[] val) {
            if (F2wPoly.this.r != this.value.length) {
                throw new IllegalArgumentException("Array length must be equal to r (" + F2wPoly.this.r + ")");
            }
            for (int i = 0; i < F2wPoly.this.r; ++i) {
                val[i] = this.value[i].value;
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("{");
            for (int i = 0; i < F2wPoly.this.r - 1; ++i) {
                sb.append(this.value[i].toString() + ", " + PrintfFormat.NEWLINE + " ");
            }
            if (F2wPoly.this.r > 0) {
                sb.append(this.value[F2wPoly.this.r - 1].toString());
            }
            sb.append("}");
            return sb.toString();
        }
    }

    public static class F2w {
        private int w;
        private int modQ;
        private F2wElem[] zeta_i;

        public F2w(int modQ) {
            this(32, modQ);
        }

        private F2w(int w, int modQ) {
            this.w = w;
            this.modQ = modQ;
            this.zeta_i = new F2wElem[w];
            this.zeta_i[0] = new F2wElem(Integer.MIN_VALUE);
            for (int i = 1; i < w; ++i) {
                this.zeta_i[i] = this.zeta_i[i - 1].multiplyZeta(2);
            }
        }

        public F2wElem createElem() {
            return new F2wElem();
        }

        public F2wElem createElem(F2wElem that) {
            return new F2wElem(that);
        }

        public F2wElem createElem(int val) {
            return new F2wElem(val);
        }

        public int getDim() {
            return this.w;
        }

        public int getModulo() {
            return this.modQ;
        }

        public class F2wElem {
            private int value;

            private F2wElem() {
                this.value = 0;
            }

            private F2wElem(F2wElem that) {
                if (this.getBase() != that.getBase()) {
                    throw new IllegalArgumentException("The copied F2wElem must originate from the same F2w.");
                }
                this.value = that.value;
            }

            private F2wElem(int val) {
                this.value = val;
            }

            public F2w getBase() {
                return F2w.this;
            }

            public int getValue() {
                return this.value;
            }

            public F2wElem multiplyZeta(int k) {
                int res = this.value;
                if (k == 0) {
                    return new F2wElem(res);
                }
                for (int i = 0; i < k; ++i) {
                    if ((1 & res) != 0) {
                        res = res >>> 1 ^ F2w.this.modQ;
                        continue;
                    }
                    res >>>= 1;
                }
                return new F2wElem(res);
            }

            public F2wElem multiply(F2wElem that) {
                if (this.getBase() != that.getBase()) {
                    throw new IllegalArgumentException("Both F2wElem must originate from the same F2w.");
                }
                int res = 0;
                int verif = 1;
                for (int i = F2w.this.w - 1; i >= 0; --i) {
                    if ((that.value & verif) != 0) {
                        res ^= this.multiplyZeta((int)i).value;
                    }
                    verif <<= 1;
                }
                return new F2wElem(res);
            }

            public F2wElem square() {
                int res = 0;
                for (int i = 0; i < F2w.this.w; ++i) {
                    if ((this.value & Integer.MIN_VALUE >>> i) == 0) continue;
                    res ^= ((F2w)F2w.this).zeta_i[i].value;
                }
                return new F2wElem(res);
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                int temp = this.value;
                for (int i = 0; i < 32; ++i) {
                    sb.append((temp & 1) == 1 ? (char)'1' : '0');
                    temp >>>= 1;
                }
                return sb.reverse().toString();
            }
        }
    }
}

