/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.util.Num;

public class NormalInverseGaussianDist
extends ContinuousDistribution {
    protected double alpha;
    protected double beta;
    protected double gamma;
    protected double delta;
    protected double mu;

    public NormalInverseGaussianDist(double alpha, double beta, double mu, double delta) {
        this.setParams(alpha, beta, mu, delta);
    }

    public double density(double x) {
        return NormalInverseGaussianDist.density(this.alpha, this.beta, this.mu, this.delta, x);
    }

    public double cdf(double x) {
        return NormalInverseGaussianDist.cdf(this.alpha, this.beta, this.mu, this.delta, x);
    }

    public double barF(double x) {
        return NormalInverseGaussianDist.barF(this.alpha, this.beta, this.mu, this.delta, x);
    }

    public double getMean() {
        return NormalInverseGaussianDist.getMean(this.alpha, this.beta, this.mu, this.delta);
    }

    public double getVariance() {
        return NormalInverseGaussianDist.getVariance(this.alpha, this.beta, this.mu, this.delta);
    }

    public double getStandardDeviation() {
        return NormalInverseGaussianDist.getStandardDeviation(this.alpha, this.beta, this.mu, this.delta);
    }

    public static double density(double alpha, double beta, double mu, double delta, double x) {
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (Math.abs(beta) >= alpha) {
            throw new IllegalArgumentException("|beta| >= alpha");
        }
        double gamma = Math.sqrt(alpha * alpha - beta * beta);
        double z = (x - mu) / delta;
        double w = Math.abs(z) <= 1.0E10 ? Math.sqrt(1.0 + z * z) : Math.abs(z);
        double y = alpha * delta * w;
        double v = delta * (gamma + beta * z);
        double R = Num.expBesselK1(v, y);
        return alpha * R / (Math.PI * w);
    }

    public static double cdf(double alpha, double beta, double mu, double delta, double x) {
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (Math.abs(beta) >= alpha) {
            throw new IllegalArgumentException("|beta| >= alpha");
        }
        double gamma = Math.sqrt(alpha * alpha - beta * beta);
        double z = (x - mu) / delta;
        if (z > 0.0 && gamma + (beta - alpha) * z >= 100.0) {
            return 1.0;
        }
        if (z < 0.0 && gamma + (beta + alpha) * z <= -1000.0) {
            return 0.0;
        }
        throw new UnsupportedOperationException("NormalInverseGaussianDist:   cdf NOT IMPLEMENTED");
    }

    public static double barF(double alpha, double beta, double mu, double delta, double x) {
        return 1.0 - NormalInverseGaussianDist.cdf(alpha, beta, mu, delta, x);
    }

    public static double inverseF(double alpha, double beta, double mu, double delta, double u) {
        throw new UnsupportedOperationException(" Inversion NOT IMPLEMENTED");
    }

    public static double[] getMLE(double[] x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        throw new UnsupportedOperationException("getMLE is not implemented");
    }

    public static NormalInverseGaussianDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = NormalInverseGaussianDist.getMLE(x, n);
        return new NormalInverseGaussianDist(parameters[0], parameters[1], parameters[2], parameters[3]);
    }

    public static double getMean(double alpha, double beta, double mu, double delta) {
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (Math.abs(beta) >= alpha) {
            throw new IllegalArgumentException("|beta| >= alpha");
        }
        double gamma = Math.sqrt(alpha * alpha - beta * beta);
        return mu + delta * beta / gamma;
    }

    public static double getVariance(double alpha, double beta, double mu, double delta) {
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (Math.abs(beta) >= alpha) {
            throw new IllegalArgumentException("|beta| >= alpha");
        }
        double gamma = Math.sqrt(alpha * alpha - beta * beta);
        return delta * alpha * alpha / (gamma * gamma * gamma);
    }

    public static double getStandardDeviation(double alpha, double beta, double mu, double delta) {
        return Math.sqrt(NormalInverseGaussianDist.getVariance(alpha, beta, mu, delta));
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getMu() {
        return this.mu;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setParams(double alpha, double beta, double mu, double delta) {
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (Math.abs(beta) >= alpha) {
            throw new IllegalArgumentException("|beta| >= alpha");
        }
        this.gamma = Math.sqrt(alpha * alpha - beta * beta);
        this.mu = mu;
        this.delta = delta;
        this.beta = beta;
        this.alpha = alpha;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.alpha, this.beta, this.mu, this.delta};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": alpha = " + this.alpha + ", beta = " + this.beta + ", mu = " + this.mu + ", delta = " + this.delta;
    }
}

