/*
 * Decompiled with CFR 0.152.
 */
package roemetz.core;

import mrmc.core.DBRecord;
import mrmc.gui.SizePanel;
import umontreal.iro.lecuyer.probdist.NormalDist;

public class CalcGenRoeMetz {
    public static DBRecord DBRecordNumerical = new DBRecord();

    public static void main(String[] args) {
        try {
            double[] u = new double[2];
            String[] us = args[0].substring(args[0].lastIndexOf("[") + 1, args[0].indexOf("]")).split(",");
            if (us.length != 2) {
                System.out.println("Expected input u to contain 2 elements");
                return;
            }
            u = new double[]{Double.parseDouble(us[0]), Double.parseDouble(us[1])};
            double[] var_t = new double[18];
            String[] var_ts = args[1].substring(args[1].indexOf("[") + 1, args[1].indexOf("]")).split(",");
            if (var_ts.length != 18) {
                System.out.println("Expected input var_t to contain 18 elements");
                return;
            }
            int i = 0;
            while (i < var_ts.length) {
                var_t[i] = Double.parseDouble(var_ts[i]);
                ++i;
            }
            String[] ns = args[2].substring(args[2].lastIndexOf("[") + 1, args[0].indexOf("]")).split(",");
            if (ns.length != 2) {
                System.out.println("Expected input n to contain 3 elements");
                return;
            }
            int Nnormal = Integer.parseInt(ns[0]);
            int Ndisease = Integer.parseInt(ns[1]);
            int n = Integer.parseInt(ns[2]);
        }
        catch (NumberFormatException e) {
            System.out.println("Incorrectly Formatted Input");
            e.printStackTrace();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Missing Arguments");
            System.out.println("Format is: CofVGenRoeMetz [u0,u1] [R00,C00,RC00,R10,C10,RC10,R01,C01,RC01,R11,C11,RC11,R0,C0,RC0,R1,C1,RC1] [n0,n1,nr]");
        }
    }

    private static double prodMomentSingleModality(double[] u, double sigmaSqOmega, double sigmaSqOmegaMoment, double sigmaSqOneMod, double sigmaSqOneModMoment, int numSamples) {
        NormalDist gaussNew = new NormalDist();
        double tempNum = Math.sqrt(sigmaSqOmega + sigmaSqOneMod - sigmaSqOmegaMoment - sigmaSqOneModMoment);
        double tempDen = Math.sqrt(sigmaSqOmegaMoment + sigmaSqOneModMoment);
        double lx = 10.0;
        double dx = lx / (double)numSamples;
        double[] x = new double[numSamples];
        double Integral = 0.0;
        int i = 0;
        while (i < numSamples) {
            x[i] = (double)i * dx - 0.5 * lx;
            ++i;
        }
        double[] phi_x = new double[numSamples];
        double[] cdfOneMod = new double[numSamples];
        int i2 = 0;
        while (i2 < numSamples) {
            phi_x[i2] = Math.exp(-(x[i2] * x[i2]) / 2.0) / Math.sqrt(Math.PI * 2);
            cdfOneMod[i2] = tempDen != 0.0 ? gaussNew.cdf((u[0] + x[i2] * tempNum) / tempDen) : 1.0;
            Integral += dx * phi_x[i2] * cdfOneMod[i2] * cdfOneMod[i2];
            ++i2;
        }
        return Integral;
    }

    private static double prodMomentTwoModalities(double[] u, double sigmaSqOmega, double sigmaSqOmegaMoment, double sigmaSqA, double sigmaSqB, int numSamples) {
        NormalDist gaussNew = new NormalDist();
        double tempNumA = Math.sqrt(sigmaSqOmega - sigmaSqOmegaMoment);
        double tempNumB = Math.sqrt(sigmaSqOmega - sigmaSqOmegaMoment);
        double tempDenA = Math.sqrt(sigmaSqA + sigmaSqOmegaMoment);
        double tempDenB = Math.sqrt(sigmaSqB + sigmaSqOmegaMoment);
        double lx = 10.0;
        double dx = lx / (double)numSamples;
        double[] x = new double[numSamples];
        double Integral = 0.0;
        int i = 0;
        while (i < numSamples) {
            x[i] = (double)i * dx - 0.5 * lx;
            ++i;
        }
        double[] phi_x = new double[numSamples];
        double[] cdf_A = new double[numSamples];
        double[] cdf_B = new double[numSamples];
        int i2 = 0;
        while (i2 < numSamples) {
            phi_x[i2] = Math.exp(-(x[i2] * x[i2]) / 2.0) / Math.sqrt(Math.PI * 2);
            cdf_A[i2] = tempDenA != 0.0 ? gaussNew.cdf((u[0] + x[i2] * tempNumA) / tempDenA) : 1.0;
            cdf_B[i2] = tempDenB != 0.0 ? gaussNew.cdf((u[1] + x[i2] * tempNumB) / tempDenB) : 1.0;
            Integral += dx * phi_x[i2] * cdf_A[i2] * cdf_B[i2];
            ++i2;
        }
        return Integral;
    }

    public static void genRoeMetz(double[] u, double[] var_t, SizePanel SizePanelRoeMetz) {
        CalcGenRoeMetz.DBRecordNumerical.Nreader = Integer.parseInt(SizePanelRoeMetz.NreaderJTextField.getText());
        CalcGenRoeMetz.DBRecordNumerical.Nnormal = Integer.parseInt(SizePanelRoeMetz.NnormalJTextField.getText());
        CalcGenRoeMetz.DBRecordNumerical.Ndisease = Integer.parseInt(SizePanelRoeMetz.NdiseaseJTextField.getText());
        int numSamples = 256;
        NormalDist gaussNew = new NormalDist();
        double v_AR0 = var_t[0];
        double v_AC0 = var_t[1];
        double v_ARC0 = var_t[2];
        double v_AR1 = var_t[3];
        double v_AC1 = var_t[4];
        double v_ARC1 = var_t[5];
        double v_BR0 = var_t[6];
        double v_BC0 = var_t[7];
        double v_BRC0 = var_t[8];
        double v_BR1 = var_t[9];
        double v_BC1 = var_t[10];
        double v_BRC1 = var_t[11];
        double v_R0 = var_t[12];
        double v_C0 = var_t[13];
        double v_RC0 = var_t[14];
        double v_R1 = var_t[15];
        double v_C1 = var_t[16];
        double v_RC1 = var_t[17];
        double sigmaSqOmega = v_R0 + v_C0 + v_RC0 + v_R1 + v_C1 + v_RC1;
        double sigmaSqA = v_AR0 + v_AC0 + v_ARC0 + v_AR1 + v_AC1 + v_ARC1;
        double sigmaSqB = v_BR0 + v_BC0 + v_BRC0 + v_BR1 + v_BC1 + v_BRC1;
        double sigmaSqAMoment = 0.0;
        double sigmaSqBMoment = 0.0;
        double sigmaSqOmegaMoment = 0.0;
        CalcGenRoeMetz.DBRecordNumerical.AUCsReaderAvg = new double[2];
        CalcGenRoeMetz.DBRecordNumerical.AUCs = new double[(int)CalcGenRoeMetz.DBRecordNumerical.Nreader][2];
        CalcGenRoeMetz.DBRecordNumerical.AUCsReaderAvg[0] = gaussNew.cdf(u[0] / Math.sqrt(sigmaSqOmega + sigmaSqA));
        CalcGenRoeMetz.DBRecordNumerical.AUCsReaderAvg[1] = gaussNew.cdf(u[1] / Math.sqrt(sigmaSqOmega + sigmaSqB));
        int r = 0;
        while ((long)r < CalcGenRoeMetz.DBRecordNumerical.Nreader) {
            CalcGenRoeMetz.DBRecordNumerical.AUCs[r][0] = CalcGenRoeMetz.DBRecordNumerical.AUCsReaderAvg[0];
            CalcGenRoeMetz.DBRecordNumerical.AUCs[r][1] = CalcGenRoeMetz.DBRecordNumerical.AUCsReaderAvg[1];
            ++r;
        }
        CalcGenRoeMetz.DBRecordNumerical.BDG[0][0] = CalcGenRoeMetz.DBRecordNumerical.AUCsReaderAvg[0];
        CalcGenRoeMetz.DBRecordNumerical.BDG[1][0] = CalcGenRoeMetz.DBRecordNumerical.AUCsReaderAvg[1];
        CalcGenRoeMetz.DBRecordNumerical.BDG[2][0] = CalcGenRoeMetz.prodMomentTwoModalities(new double[]{u[0], u[1]}, sigmaSqOmega, sigmaSqOmegaMoment, sigmaSqA, sigmaSqB, 256);
        sigmaSqAMoment = v_AC0 + v_ARC0;
        sigmaSqBMoment = v_BC0 + v_BRC0;
        sigmaSqOmegaMoment = v_C0 + v_RC0;
        CalcGenRoeMetz.DBRecordNumerical.BDG[0][1] = CalcGenRoeMetz.prodMomentSingleModality(new double[]{u[0], u[0]}, sigmaSqOmega, sigmaSqOmegaMoment, sigmaSqA, sigmaSqAMoment, 256);
        CalcGenRoeMetz.DBRecordNumerical.BDG[1][1] = CalcGenRoeMetz.prodMomentSingleModality(new double[]{u[1], u[1]}, sigmaSqOmega, sigmaSqOmegaMoment, sigmaSqB, sigmaSqBMoment, 256);
        CalcGenRoeMetz.DBRecordNumerical.BDG[2][1] = CalcGenRoeMetz.prodMomentTwoModalities(new double[]{u[0], u[1]}, sigmaSqOmega, sigmaSqOmegaMoment, sigmaSqA, sigmaSqB, 256);
        sigmaSqAMoment = v_AC1 + v_ARC1;
        sigmaSqBMoment = v_BC1 + v_BRC1;
        sigmaSqOmegaMoment = v_C1 + v_RC1;
        CalcGenRoeMetz.DBRecordNumerical.BDG[0][2] = CalcGenRoeMetz.prodMomentSingleModality(new double[]{u[0], u[0]}, sigmaSqOmega, sigmaSqOmegaMoment, sigmaSqA, sigmaSqAMoment, 256);
        CalcGenRoeMetz.DBRecordNumerical.BDG[1][2] = CalcGenRoeMetz.prodMomentSingleModality(new double[]{u[1], u[1]}, sigmaSqOmega, sigmaSqOmegaMoment, sigmaSqB, sigmaSqBMoment, 256);
        CalcGenRoeMetz.DBRecordNumerical.BDG[2][2] = CalcGenRoeMetz.prodMomentTwoModalities(new double[]{u[0], u[1]}, sigmaSqOmega, sigmaSqOmegaMoment, sigmaSqA, sigmaSqB, 256);
        sigmaSqAMoment = v_AC1 + v_ARC1 + v_AC0 + v_ARC0;
        sigmaSqBMoment = v_BC1 + v_BRC1 + v_BC0 + v_BRC0;
        sigmaSqOmegaMoment = v_C1 + v_RC1 + v_C0 + v_RC0;
        CalcGenRoeMetz.DBRecordNumerical.BDG[0][3] = CalcGenRoeMetz.prodMomentSingleModality(new double[]{u[0], u[0]}, sigmaSqOmega, sigmaSqOmegaMoment, sigmaSqA, sigmaSqAMoment, 256);
        CalcGenRoeMetz.DBRecordNumerical.BDG[1][3] = CalcGenRoeMetz.prodMomentSingleModality(new double[]{u[1], u[1]}, sigmaSqOmega, sigmaSqOmegaMoment, sigmaSqB, sigmaSqBMoment, 256);
        CalcGenRoeMetz.DBRecordNumerical.BDG[2][3] = CalcGenRoeMetz.prodMomentTwoModalities(new double[]{u[0], u[1]}, sigmaSqOmega, sigmaSqOmegaMoment, sigmaSqA, sigmaSqB, 256);
        sigmaSqAMoment = v_AR0 + v_ARC0 + v_AR1 + v_ARC1;
        sigmaSqBMoment = v_BR0 + v_BRC0 + v_BR1 + v_BRC1;
        sigmaSqOmegaMoment = v_R0 + v_RC0 + v_R1 + v_RC1;
        CalcGenRoeMetz.DBRecordNumerical.BDG[0][4] = CalcGenRoeMetz.prodMomentSingleModality(new double[]{u[0], u[0]}, sigmaSqOmega, sigmaSqOmegaMoment, sigmaSqA, sigmaSqAMoment, 256);
        CalcGenRoeMetz.DBRecordNumerical.BDG[1][4] = CalcGenRoeMetz.prodMomentSingleModality(new double[]{u[1], u[1]}, sigmaSqOmega, sigmaSqOmegaMoment, sigmaSqB, sigmaSqBMoment, 256);
        CalcGenRoeMetz.DBRecordNumerical.BDG[2][4] = CalcGenRoeMetz.prodMomentTwoModalities(new double[]{u[0], u[1]}, sigmaSqOmega, sigmaSqOmegaMoment, sigmaSqA, sigmaSqB, 256);
        sigmaSqAMoment = v_AR0 + v_AC0 + v_ARC0 + v_AR1 + v_ARC1;
        sigmaSqBMoment = v_BR0 + v_BC0 + v_BRC0 + v_BR1 + v_BRC1;
        sigmaSqOmegaMoment = v_R0 + v_C0 + v_RC0 + v_R1 + v_RC1;
        CalcGenRoeMetz.DBRecordNumerical.BDG[0][5] = CalcGenRoeMetz.prodMomentSingleModality(new double[]{u[0], u[0]}, sigmaSqOmega, sigmaSqOmegaMoment, sigmaSqA, sigmaSqAMoment, 256);
        CalcGenRoeMetz.DBRecordNumerical.BDG[1][5] = CalcGenRoeMetz.prodMomentSingleModality(new double[]{u[1], u[1]}, sigmaSqOmega, sigmaSqOmegaMoment, sigmaSqB, sigmaSqBMoment, 256);
        CalcGenRoeMetz.DBRecordNumerical.BDG[2][5] = CalcGenRoeMetz.prodMomentTwoModalities(new double[]{u[0], u[1]}, sigmaSqOmega, sigmaSqOmegaMoment, sigmaSqA, sigmaSqB, 256);
        sigmaSqAMoment = v_AR0 + v_ARC0 + v_AR1 + v_AC1 + v_ARC1;
        sigmaSqBMoment = v_BR0 + v_BRC0 + v_BR1 + v_BC1 + v_BRC1;
        sigmaSqOmegaMoment = v_R0 + v_RC0 + v_R1 + v_C1 + v_RC1;
        CalcGenRoeMetz.DBRecordNumerical.BDG[0][6] = CalcGenRoeMetz.prodMomentSingleModality(new double[]{u[0], u[0]}, sigmaSqOmega, sigmaSqOmegaMoment, sigmaSqA, sigmaSqAMoment, 256);
        CalcGenRoeMetz.DBRecordNumerical.BDG[1][6] = CalcGenRoeMetz.prodMomentSingleModality(new double[]{u[1], u[1]}, sigmaSqOmega, sigmaSqOmegaMoment, sigmaSqB, sigmaSqBMoment, 256);
        CalcGenRoeMetz.DBRecordNumerical.BDG[2][6] = CalcGenRoeMetz.prodMomentTwoModalities(new double[]{u[0], u[1]}, sigmaSqOmega, sigmaSqOmegaMoment, sigmaSqA, sigmaSqB, 256);
        CalcGenRoeMetz.DBRecordNumerical.BDG[0][7] = CalcGenRoeMetz.DBRecordNumerical.AUCsReaderAvg[0] * CalcGenRoeMetz.DBRecordNumerical.AUCsReaderAvg[0];
        CalcGenRoeMetz.DBRecordNumerical.BDG[1][7] = CalcGenRoeMetz.DBRecordNumerical.AUCsReaderAvg[1] * CalcGenRoeMetz.DBRecordNumerical.AUCsReaderAvg[1];
        CalcGenRoeMetz.DBRecordNumerical.BDG[2][7] = CalcGenRoeMetz.DBRecordNumerical.AUCsReaderAvg[0] * CalcGenRoeMetz.DBRecordNumerical.AUCsReaderAvg[1];
        DBRecordNumerical.DBRecordRoeMetzNumericalFill(SizePanelRoeMetz);
        if (SizePanelRoeMetz.pairedReadersFlag == 0) {
            int i = 0;
            while ((long)i < CalcGenRoeMetz.DBRecordNumerical.Nreader / 2L) {
                CalcGenRoeMetz.DBRecordNumerical.N0perReader[i][1] = 0;
                CalcGenRoeMetz.DBRecordNumerical.N1perReader[i][1] = 0;
                CalcGenRoeMetz.DBRecordNumerical.N0perReader[i][2] = 0;
                CalcGenRoeMetz.DBRecordNumerical.N1perReader[i][2] = 0;
                CalcGenRoeMetz.DBRecordNumerical.AUCs[i][1] = Double.NaN;
                ++i;
            }
            i = (int)(CalcGenRoeMetz.DBRecordNumerical.Nreader / 2L);
            while ((long)i < CalcGenRoeMetz.DBRecordNumerical.Nreader) {
                CalcGenRoeMetz.DBRecordNumerical.N0perReader[i][0] = 0;
                CalcGenRoeMetz.DBRecordNumerical.N1perReader[i][0] = 0;
                CalcGenRoeMetz.DBRecordNumerical.N0perReader[i][2] = 0;
                CalcGenRoeMetz.DBRecordNumerical.N1perReader[i][2] = 0;
                CalcGenRoeMetz.DBRecordNumerical.AUCs[i][0] = Double.NaN;
                ++i;
            }
        }
    }
}

