/*
 * Decompiled with CFR 0.152.
 */
package haplotype;

import beagleutil.Samples;
import haplotype.SampleHapPairs;
import vcf.Marker;
import vcf.Markers;

public final class RevSampleHapPairs
implements SampleHapPairs {
    private final SampleHapPairs hapPairs;
    private final int lastMarker;

    public RevSampleHapPairs(SampleHapPairs sampleHapPairs) {
        this.hapPairs = sampleHapPairs;
        this.lastMarker = sampleHapPairs.nMarkers() - 1;
    }

    @Override
    public int allele1(int n, int n2) {
        return this.hapPairs.allele1(this.lastMarker - n, n2);
    }

    @Override
    public int allele2(int n, int n2) {
        return this.hapPairs.allele2(this.lastMarker - n, n2);
    }

    @Override
    public int allele(int n, int n2) {
        return this.hapPairs.allele(this.lastMarker - n, n2);
    }

    @Override
    public int nMarkers() {
        return this.hapPairs.nMarkers();
    }

    @Override
    public Markers markers() {
        return this.hapPairs.markers().reverse();
    }

    @Override
    public Marker marker(int n) {
        return this.hapPairs.marker(this.lastMarker - n);
    }

    @Override
    public int nHaps() {
        return this.hapPairs.nHaps();
    }

    @Override
    public int nHapPairs() {
        return this.hapPairs.nHapPairs();
    }

    @Override
    public int nSamples() {
        return this.hapPairs.nSamples();
    }

    @Override
    public Samples samples() {
        return this.hapPairs.samples();
    }

    @Override
    public Samples samples(int n) {
        return this.hapPairs.samples(n);
    }

    @Override
    public int sampleIndex(int n) {
        return this.hapPairs.sampleIndex(n);
    }

    @Override
    public int nAlleles(int n) {
        return this.hapPairs.nAlleles(this.lastMarker - n);
    }

    @Override
    public boolean storesNonMajorIndices(int n) {
        return this.hapPairs.storesNonMajorIndices(this.lastMarker - n);
    }

    @Override
    public int majorAllele(int n) {
        return this.hapPairs.majorAllele(this.lastMarker - n);
    }

    @Override
    public int alleleCount(int n, int n2) {
        return this.hapPairs.alleleCount(this.lastMarker - n, n2);
    }

    @Override
    public int hapIndex(int n, int n2, int n3) {
        return this.hapPairs.hapIndex(this.lastMarker - n, n2, n3);
    }
}

