/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Content;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.assembler.assemblers.ContentAssembler;
import com.hp.hpl.jena.assembler.assemblers.PrefixMappingAssembler;
import com.hp.hpl.jena.assembler.exceptions.TransactionAbortedException;
import com.hp.hpl.jena.assembler.exceptions.UnknownStyleException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import java.util.ArrayList;

public abstract class ModelAssembler
extends AssemblerBase
implements Assembler {
    protected abstract Model openModel(Assembler var1, Resource var2, Mode var3);

    public Object open(Assembler a, Resource root, Mode mode) {
        Model m = this.openModel(a, root, mode);
        Content c = this.getContent(a, root);
        if (m.supportsTransactions()) {
            m.begin();
            try {
                c.fill(m);
                m.commit();
            }
            catch (Throwable t) {
                m.abort();
                throw new TransactionAbortedException(root, t);
            }
        } else {
            c.fill(m);
        }
        m.setNsPrefixes(this.getPrefixMapping(a, root));
        return m;
    }

    public static ReificationStyle getReificationStyle(Resource root) {
        Resource r = ModelAssembler.getUniqueResource(root, JA.reificationMode);
        return r == null ? ReificationStyle.Standard : ModelAssembler.styleFor(root, r);
    }

    public static ReificationStyle styleFor(Resource root, Resource r) {
        if (((Object)r).equals(JA.minimal)) {
            return ReificationStyle.Minimal;
        }
        if (((Object)r).equals(JA.standard)) {
            return ReificationStyle.Standard;
        }
        if (((Object)r).equals(JA.convenient)) {
            return ReificationStyle.Convenient;
        }
        throw new UnknownStyleException(root, r);
    }

    private PrefixMapping getPrefixMapping(Assembler a, Resource root) {
        return PrefixMappingAssembler.getPrefixes(a, root, PrefixMapping.Factory.create());
    }

    public Model openModel(Resource root, Mode mode) {
        return (Model)this.open(this, root, mode);
    }

    protected Content getContent(Assembler a, Resource root) {
        return new Content(ContentAssembler.loadContent(new ArrayList(), a, root));
    }
}

