/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.tools;

public final class MathUtils {
    public static final double ROUNDED_LOG_PRECISION = 10000.0;
    public static final double LOG10_2 = Math.log10(2.0);

    private MathUtils() {
    }

    public static long factorial(int n) {
        return n < 2 ? 1L : (long)n * MathUtils.factorial(n - 1);
    }

    public static int combinaison(int n, int p) {
        if (n == p) {
            return 1;
        }
        if (p == 0) {
            return 1;
        }
        if (p == 1) {
            return n;
        }
        return MathUtils.combinaison(n - 1, p) + MathUtils.combinaison(n - 1, p - 1);
    }

    public static boolean isPowerOfTwo(int x) {
        return (x & x - 1) == 0;
    }

    public static int pow(int value, int exp) {
        return value == 2 && exp >= 0 ? 1 << exp : (int)Math.pow(value, exp);
    }

    public static double log(double value, double exponent) {
        return Math.log(value) / Math.log(exponent);
    }

    public static double roundedLog(double value, double exponent) {
        return (double)Math.round(MathUtils.log(value, exponent) * 10000.0) / 10000.0;
    }

    public static int sum(int[] values, int begin, int end) {
        int s = 0;
        for (int i = begin; i < end; ++i) {
            s += values[i];
        }
        return s;
    }

    public static int sumFrom(int[] values, int begin) {
        return MathUtils.sum(values, begin, values.length);
    }

    public static int sumTo(int[] values, int end) {
        return MathUtils.sum(values, 0, end);
    }

    public static int sum(int[] values) {
        return MathUtils.sum(values, 0, values.length);
    }

    public static int sum(int[][] values) {
        int s = 0;
        for (int[] value : values) {
            for (int j = 0; j < value.length; ++j) {
                s += value[j];
            }
        }
        return s;
    }

    public static int max(int[] values) {
        int max = Integer.MIN_VALUE;
        for (int value : values) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public static int max(int[][] values) {
        int max = Integer.MIN_VALUE;
        for (int[] value : values) {
            for (int j = 0; j < value.length; ++j) {
                if (value[j] <= max) continue;
                max = value[j];
            }
        }
        return max;
    }

    public static int min(int[] values) {
        int min = Integer.MAX_VALUE;
        for (int value : values) {
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public static int min(int[][] values) {
        int min = Integer.MAX_VALUE;
        for (int[] value : values) {
            for (int j = 0; j < value.length; ++j) {
                if (value[j] >= min) continue;
                min = value[j];
            }
        }
        return min;
    }

    public static int divFloor(int x, int y) {
        if (y == 0) {
            return Integer.MAX_VALUE;
        }
        return Math.floorDiv(x, y);
    }

    public static int divCeil(int x, int y) {
        if (y == 0) {
            return Integer.MIN_VALUE;
        }
        int r = x / y;
        if ((x ^ y) > 0 && r * y != x) {
            ++r;
        }
        return r;
    }

    public static int safeAdd(int x, int y) {
        int r = x + y;
        if (((x ^ r) & (y ^ r)) < 0) {
            long rr = (long)x + (long)y;
            return rr > 0L ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }
        return r;
    }

    public static int safeSubstract(int x, int y) {
        int r = x - y;
        if (((x ^ y) & (x ^ r)) < 0) {
            long rr = (long)x - (long)y;
            return rr > 0L ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }
        return r;
    }

    public static int safeMultiply(int x, int y) {
        long r = (long)x * (long)y;
        if ((long)((int)r) != r) {
            return r > 0L ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }
        return (int)r;
    }

    public static int safeCast(long x) {
        if (x > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (x < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)x;
    }

    public static double log2(double a) {
        return Math.log10(a) / LOG10_2;
    }

    public static boolean isPerfectSquare(long n) {
        if (n < 0L) {
            return false;
        }
        switch ((int)(n & 0xFL)) {
            case 0: 
            case 1: 
            case 4: 
            case 9: {
                long tst = (long)Math.sqrt(n);
                return tst * tst == n;
            }
        }
        return false;
    }
}

