/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures;

import org.chocosolver.util.objects.setDataStructures.ISet;

public abstract class AbstractSet
implements ISet {
    ISet[] observing = new ISet[2];
    int[] idxInObserving = new int[2];
    int obsIdx = 0;

    @Override
    public void registerObserver(ISet set, int idx) {
        if (this.obsIdx == this.observing.length) {
            ISet[] tmp = this.observing;
            int[] tmpIdx = this.idxInObserving;
            this.observing = new ISet[tmp.length * 3 / 2 + 1];
            this.idxInObserving = new int[tmp.length * 3 / 2 + 1];
            System.arraycopy(tmp, 0, this.observing, 0, this.obsIdx);
            System.arraycopy(tmpIdx, 0, this.idxInObserving, 0, this.obsIdx);
        }
        this.observing[this.obsIdx] = set;
        this.idxInObserving[this.obsIdx] = idx;
        ++this.obsIdx;
    }

    protected void notifyObservingElementAdded(int element) {
        for (int i = 0; i < this.obsIdx; ++i) {
            this.observing[i].notifyElementAdded(element, this.idxInObserving[i]);
        }
    }

    protected void notifyObservingElementRemoved(int element) {
        for (int i = 0; i < this.obsIdx; ++i) {
            this.observing[i].notifyElementRemoved(element, this.idxInObserving[i]);
        }
    }

    protected void notifyObservingCleared() {
        for (int i = 0; i < this.obsIdx; ++i) {
            this.observing[i].notifyCleared(this.idxInObserving[i]);
        }
    }

    protected void notifyObservingAddedBetween(int from, int to) {
        for (int i = 0; i < this.obsIdx; ++i) {
            for (int e = from; e <= to; ++e) {
                this.observing[i].notifyElementAdded(e, this.idxInObserving[i]);
            }
        }
    }

    protected void notifyObservingRemovedBetween(int from, int to) {
        for (int i = 0; i < this.obsIdx; ++i) {
            for (int e = from; e <= to; ++e) {
                this.observing[i].notifyElementRemoved(e, this.idxInObserving[i]);
            }
        }
    }

    protected void notifyObservingRetainedBetween(int from, int to) {
        for (int i = 0; i < this.obsIdx; ++i) {
            this.observing[i].notifyCleared(this.idxInObserving[i]);
            for (int e = from; e <= to; ++e) {
                this.observing[i].notifyElementAdded(e, this.idxInObserving[i]);
            }
        }
    }

    protected void notifyObservingFullUpdate() {
        if (this.obsIdx == 0) {
            return;
        }
        int[] values = this.toArray();
        for (int i = 0; i < this.obsIdx; ++i) {
            this.observing[i].notifyCleared(this.idxInObserving[i]);
            for (int e : values) {
                this.observing[i].notifyElementAdded(e, this.idxInObserving[i]);
            }
        }
    }

    public String toString() {
        StringBuilder st = new StringBuilder("{");
        for (int i : this.toArray()) {
            st.append(i).append(", ");
        }
        st.append("}");
        return st.toString().replace(", }", "}");
    }
}

