/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import java.util.List;
import java.util.TreeSet;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.expression.continuous.arithmetic.CArExpression;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.delta.IDelta;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.solver.variables.impl.scheduler.RealEvtScheduler;
import org.chocosolver.util.iterators.EvtScheduler;
import org.chocosolver.util.objects.RealInterval;

public class FixedRealVarImpl
extends AbstractVariable
implements RealVar {
    double lb;
    double ub;

    public FixedRealVarImpl(String name, double value, Model model) {
        this(name, value, value, model);
    }

    public FixedRealVarImpl(String name, double lb, double ub, Model model) {
        super(name, model);
        this.lb = lb;
        this.ub = ub;
    }

    @Override
    public double getLB() {
        return this.lb;
    }

    @Override
    public double getUB() {
        return this.ub;
    }

    @Override
    public void intersect(double l, double u, ICause cause) throws ContradictionException {
    }

    @Override
    public boolean updateLowerBound(double value, ICause cause) throws ContradictionException {
        if (value > this.lb) {
            assert (cause != null);
            this.contradiction(cause, "outside domain update bound");
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(double value, ICause cause) throws ContradictionException {
        if (value < this.ub) {
            assert (cause != null);
            this.contradiction(cause, "outside domain update bound");
        }
        return false;
    }

    @Override
    public boolean updateBounds(double lowerbound, double upperbound, ICause cause) throws ContradictionException {
        if (lowerbound > this.lb || upperbound < this.ub) {
            assert (cause != null);
            this.contradiction(cause, "outside domain update bound");
        }
        return false;
    }

    @Override
    public double getPrecision() {
        return Double.MIN_VALUE;
    }

    @Override
    public void silentlyAssign(RealInterval bounds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void silentlyAssign(double lb, double ub) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInstantiated() {
        return true;
    }

    @Override
    public IDelta getDelta() {
        return NoDelta.singleton;
    }

    @Override
    public void createDelta() {
    }

    @Override
    public void notifyMonitors(IEventType event) throws ContradictionException {
    }

    @Override
    public int getTypeAndKind() {
        return 66;
    }

    protected EvtScheduler createScheduler() {
        return new RealEvtScheduler();
    }

    @Override
    public void tighten() {
    }

    @Override
    public void project(ICause cause) throws ContradictionException {
    }

    @Override
    public void collectVariables(TreeSet<RealVar> set) {
    }

    @Override
    public void subExps(List<CArExpression> list) {
        list.add(this);
    }

    @Override
    public boolean isolate(RealVar var, List<CArExpression> wx, List<CArExpression> wox) {
        return var == this;
    }

    @Override
    public void init() {
    }
}

