/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.restart;

import org.chocosolver.solver.search.restart.AbstractCutoff;

public final class LubyCutoff
extends AbstractCutoff {
    private int un = 1;
    private int vn = 1;

    public LubyCutoff(long s) {
        super(s);
    }

    @Override
    public long getNextCutoff() {
        long cutoff = this.scaleFactor * (long)this.vn * (long)this.grower.getAsInt();
        if ((this.un & -this.un) == this.vn) {
            ++this.un;
            this.vn = 1;
        } else {
            this.vn <<= 1;
        }
        return cutoff;
    }

    @Override
    public void reset() {
        this.vn = 1;
        this.un = 1;
    }

    public String toString() {
        return "LUBY(s=" + this.scaleFactor + ",log2)";
    }
}

