/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.objective;

import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.objective.IObjectiveManager;
import org.chocosolver.solver.variables.RealVar;

abstract class AbstractRealObjManager
implements IObjectiveManager<RealVar> {
    private static final long serialVersionUID = 8038511375883592639L;
    protected final transient RealVar objective;
    protected final ResolutionPolicy policy;
    protected final double precision;
    protected double bestProvedLB;
    protected double bestProvedUB;
    protected transient DoubleUnaryOperator cutComputer = n -> n;

    public AbstractRealObjManager(AbstractRealObjManager objman) {
        this.objective = objman.objective;
        this.policy = objman.policy;
        this.precision = objman.precision;
        this.bestProvedLB = objman.bestProvedLB;
        this.bestProvedUB = objman.bestProvedUB;
        this.cutComputer = objman.cutComputer;
    }

    public AbstractRealObjManager(RealVar objective, ResolutionPolicy policy, double precision) {
        assert (Objects.nonNull(objective));
        this.objective = objective;
        assert (Objects.nonNull((Object)policy));
        this.policy = policy;
        this.precision = precision;
        double prec = Math.abs(precision);
        this.bestProvedLB = objective.getLB() - prec;
        this.bestProvedUB = objective.getUB() + prec;
    }

    @Override
    public final RealVar getObjective() {
        return this.objective;
    }

    @Override
    public final ResolutionPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public final Number getBestLB() {
        return this.bestProvedLB;
    }

    @Override
    public final Number getBestUB() {
        return this.bestProvedUB;
    }

    @Override
    public final void setCutComputer(Function<Number, Number> cutComputer) {
        this.cutComputer = operand -> ((Number)cutComputer.apply(operand)).intValue();
    }

    public final void setCutComputer(DoubleUnaryOperator cutComputer) {
        this.cutComputer = cutComputer;
    }

    @Override
    public void setStrictDynamicCut() {
        this.cutComputer = n -> n + this.precision;
    }

    @Override
    public final void setWalkingDynamicCut() {
        this.cutComputer = n -> n;
    }

    public synchronized boolean updateBestLB(double lb) {
        if (this.bestProvedLB < lb) {
            this.bestProvedLB = lb;
            return true;
        }
        return false;
    }

    public synchronized boolean updateBestUB(double ub) {
        if (this.bestProvedUB > ub) {
            this.bestProvedUB = ub;
            return true;
        }
        return false;
    }

    @Override
    public boolean updateBestSolution(Number n) {
        return this.updateBestSolution(n.doubleValue());
    }

    public abstract boolean updateBestSolution(double var1);

    @Override
    public boolean updateBestSolution() {
        assert (this.objective.isInstantiated());
        return this.updateBestSolution(this.objective.getUB());
    }

    private int getNbDecimals() {
        int dec = 0;
        double p = this.precision;
        while ((int)p <= 0 && dec <= 12) {
            ++dec;
            p *= 10.0;
        }
        return dec;
    }

    @Override
    public void resetBestBounds() {
        double prec = Math.abs(this.precision);
        this.bestProvedLB = this.objective.getLB() - prec;
        this.bestProvedUB = this.objective.getUB() + prec;
    }

    public String toString() {
        return String.format("%s %s = %." + this.getNbDecimals() + "f", new Object[]{this.policy, this.objective == null ? "?" : this.objective.getName(), this.getBestSolutionValue().doubleValue()});
    }
}

