/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.min_max;

import java.util.stream.IntStream;
import org.chocosolver.memory.IStateBitSet;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropArgmax
extends Propagator<IntVar> {
    private static final boolean INCREMENTAL = false;
    private final int n;
    private final int o;
    private final IStateInt ubi;
    private final IStateInt lbi;
    private final IStateBitSet Ir;
    private final IIntDeltaMonitor delta;
    private final IntProcedure proc;

    public PropArgmax(IntVar z, int offset, IntVar[] x) {
        super((Variable[])ArrayUtils.append(x, {z}), (Priority)PropagatorPriority.LINEAR, false);
        this.n = x.length;
        this.o = offset;
        this.ubi = z.getModel().getEnvironment().makeInt(-1);
        this.lbi = z.getModel().getEnvironment().makeInt(-1);
        this.delta = null;
        this.Ir = null;
        this.proc = null;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx < this.n) {
            return IntEventType.boundAndInst();
        }
        return IntEventType.all();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ((IntVar[])this.vars)[this.n].updateLowerBound(this.o, (ICause)this);
        ((IntVar[])this.vars)[this.n].updateUpperBound(this.n + this.o - 1, (ICause)this);
        int ubi_ = this.argmaxub(IntVar::getUB);
        this.ubi.set(ubi_);
        int ub = ((IntVar[])this.vars)[ubi_].getUB();
        for (int j = 0; j < this.n; ++j) {
            if (((IntVar[])this.vars)[this.n].contains(j + this.o)) continue;
            ((IntVar[])this.vars)[j].updateUpperBound(ub - (j < ubi_ ? 1 : 0), (ICause)this);
        }
        int lbi_ = this.argmaxlb(IntVar::getLB);
        this.lbi.set(lbi_);
        int j = ((IntVar[])this.vars)[this.n].nextValueOut(-1 + this.o);
        while (j < this.n + this.o) {
            int n = j - this.o;
            j = ((IntVar[])this.vars)[this.n].nextValueOut(j);
        }
        this.filterZ();
        if (((IntVar[])this.vars)[this.n].isInstantiated()) {
            this.filterLb(((IntVar[])this.vars)[this.n].getValue() - this.o);
        }
    }

    @Override
    public void propagate(int j, int mask) throws ContradictionException {
        assert (false);
        if (j == this.n) {
            this.delta.forEachRemVal(this.proc);
            if (((IntVar[])this.vars)[this.n].isInstantiated()) {
                this.filterLb(((IntVar[])this.vars)[this.n].getValue() - this.o);
            }
        } else {
            if (IntEventType.isDecupp(mask) || IntEventType.isInstantiate(mask)) {
                if (j == this.ubi.get()) {
                    this.filterUb();
                }
                if (((IntVar[])this.vars)[j].getUB() <= ((IntVar[])this.vars)[this.lbi.get()].getLB() - (j <= this.lbi.get() ? 1 : 0)) {
                    ((IntVar[])this.vars)[this.n].removeValue(j + this.o, (ICause)this);
                }
            }
            if ((IntEventType.isInclow(mask) || IntEventType.isInstantiate(mask)) && ((IntVar[])this.vars)[j].getLB() > ((IntVar[])this.vars)[this.lbi.get()].getLB() - (j <= this.lbi.get() ? 1 : 0)) {
                this.lbi.set(j);
                if (((IntVar[])this.vars)[this.n].isInstantiated()) {
                    this.filterLb(((IntVar[])this.vars)[this.n].getValue() - this.o);
                } else {
                    this.filterZ();
                }
            }
        }
    }

    private int argmaxlb(Bound bnd) {
        int lbi = 0;
        int lb = bnd.bound(((IntVar[])this.vars)[lbi]);
        for (int i = 1; i < this.n; ++i) {
            int _lb = bnd.bound(((IntVar[])this.vars)[i]);
            if (_lb <= lb) continue;
            lb = _lb;
            lbi = i;
        }
        return lbi;
    }

    private int argmaxub(Bound bnd) {
        int ubi = ((IntVar[])this.vars)[this.n].getLB();
        int ub = bnd.bound(((IntVar[])this.vars)[ubi - this.o]);
        int i = ((IntVar[])this.vars)[this.n].nextValue(ubi);
        while (i <= ((IntVar[])this.vars)[this.n].getUB()) {
            int _ub = bnd.bound(((IntVar[])this.vars)[i - this.o]);
            if (_ub > ub) {
                ub = _ub;
                ubi = i;
            }
            i = ((IntVar[])this.vars)[this.n].nextValue(i);
        }
        return ubi - this.o;
    }

    private void filterUb() throws ContradictionException {
        assert (false);
        int ubi_ = this.argmaxub(IntVar::getUB);
        this.ubi.set(ubi_);
        int ub = ((IntVar[])this.vars)[ubi_].getUB();
        int jj = this.Ir.nextSetBit(0);
        while (jj > -1) {
            ((IntVar[])this.vars)[jj].updateUpperBound(ub - (jj < ubi_ ? 1 : 0), (ICause)this);
            jj = this.Ir.nextSetBit(jj + 1);
        }
    }

    private void filterZ() throws ContradictionException {
        int lbi_ = this.lbi.get();
        int lb = ((IntVar[])this.vars)[lbi_].getLB();
        int j = ((IntVar[])this.vars)[this.n].getLB();
        while (j <= ((IntVar[])this.vars)[this.n].getUB()) {
            int jj = j - this.o;
            if (((IntVar[])this.vars)[jj].getUB() <= lb - (jj <= lbi_ ? 1 : 0)) {
                ((IntVar[])this.vars)[this.n].removeValue(j, (ICause)this);
            }
            j = ((IntVar[])this.vars)[this.n].nextValue(j);
        }
    }

    private void filterLb(int j) throws ContradictionException {
        int lbi_ = this.lbi.get();
        ((IntVar[])this.vars)[j].updateLowerBound(((IntVar[])this.vars)[lbi_].getLB() + (lbi_ < j ? 1 : 0), (ICause)this);
        this.lbi.set(j);
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            int max = IntStream.range(0, this.n).map(i -> ((IntVar[])this.vars)[i].getValue()).max().getAsInt();
            int frst = IntStream.range(0, this.n).filter(i -> ((IntVar[])this.vars)[i].getValue() == max).findFirst().getAsInt();
            return ESat.eval(((IntVar[])this.vars)[this.n].getValue() == frst + this.o && ((IntVar[])this.vars)[frst].getValue() == max);
        }
        return ESat.UNDEFINED;
    }

    private /* synthetic */ void lambda$new$0(int j) throws ContradictionException {
        int jj = j - this.o;
        int lbi_ = this.lbi.get();
        int ubi_ = this.ubi.get();
        this.Ir.set(jj, ((IntVar[])this.vars)[jj].getUB() > ((IntVar[])this.vars)[lbi_].getLB() - (jj <= lbi_ ? 1 : 0));
        if (jj == ubi_) {
            this.filterUb();
        } else {
            int ub = ((IntVar[])this.vars)[ubi_].getUB();
            ((IntVar[])this.vars)[jj].updateUpperBound(ub - (jj < ubi_ ? 1 : 0), (ICause)this);
        }
    }

    @FunctionalInterface
    private static interface Bound {
        public int bound(IntVar var1);
    }
}

