/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.knapsack.structure;

import java.util.List;
import org.chocosolver.solver.constraints.nary.knapsack.structure.BinarySearchFingerTree;
import org.chocosolver.solver.constraints.nary.knapsack.structure.Info;
import org.chocosolver.solver.constraints.nary.knapsack.structure.InnerNodeSum;
import org.chocosolver.solver.constraints.nary.knapsack.structure.KPItem;
import org.chocosolver.solver.constraints.nary.knapsack.structure.ProfitInterface;
import org.chocosolver.solver.constraints.nary.knapsack.structure.SearchInfos;

public class ComputingLossWeightTree
extends BinarySearchFingerTree {
    public static final double OFFSET = 1.0E-4;

    public ComputingLossWeightTree(List<KPItem> sortedItems) {
        super(sortedItems, InnerNodeSum::new);
    }

    private ProfitInterface getNodeProfitInterface(int index) {
        if (this.isLeaf(index)) {
            return (ProfitInterface)this.getLeaf(index);
        }
        if (this.isInnerNode(index)) {
            return (ProfitInterface)this.getInnerNode(index);
        }
        throw new IndexOutOfBoundsException("Looking for an index that corresponds to nothing in the tree (leaf outside of range)");
    }

    public int getNodeProfit(int index) {
        return this.getNodeProfitInterface(index).getProfit();
    }

    public boolean isTrivial(int capacity) {
        return this.getNodeWeight(0) <= capacity;
    }

    public Info findCriticalItem(int capacity) {
        int remainingCapacity = capacity;
        double criticalProfit = 0.0;
        int criticalIdx = 0;
        if (capacity < 0) {
            return new Info(this.getNumberNodes() - this.getNumberLeaves(), 0.0, 0, 0);
        }
        if (this.isTrivial(capacity)) {
            return new Info(this.getNumberNodes(), this.getNodeProfit(0), this.getNodeProfit(0), this.getNodeWeight(0));
        }
        while (this.isInnerNode(criticalIdx)) {
            int leftChild = this.getLeftChild(criticalIdx);
            int rightChild = this.getRightChild(criticalIdx);
            if (this.isLeaf(leftChild) || this.isInnerNode(leftChild)) {
                if (this.getNodeWeight(leftChild) >= remainingCapacity) {
                    criticalIdx = leftChild;
                    continue;
                }
                criticalIdx = rightChild;
                remainingCapacity -= this.getNodeWeight(leftChild);
                criticalProfit += (double)this.getNodeProfit(leftChild);
                continue;
            }
            throw new RuntimeException("Finding a critical item led to an empty Item, but kp is not trivial");
        }
        return new Info(criticalIdx, criticalProfit += ((KPItem)this.getLeaf(criticalIdx)).getEfficiency() * (double)remainingCapacity, capacity - remainingCapacity, capacity);
    }

    public SearchInfos computeLimitWeightMandatory(Info criticalInfos, int itemIndex, int startingIndex, double profitAccumulated, double weightAccumulated, double allowedProfitLoss, double startItemWeight) {
        assert (!this.isInnerNode(startingIndex));
        boolean decision = false;
        if (criticalInfos.index == this.getNumberNodes()) {
            decision = (double)this.getNodeProfit(itemIndex) > allowedProfitLoss + 1.0E-4;
            return new SearchInfos(decision, startingIndex, profitAccumulated, weightAccumulated, startItemWeight);
        }
        if (this.getNodeWeight(itemIndex) == 0) {
            decision = (double)this.getNodeProfit(itemIndex) > allowedProfitLoss + 1.0E-4;
            return new SearchInfos(decision, startingIndex, profitAccumulated, weightAccumulated, startItemWeight);
        }
        double itemWeight = this.getNodeWeight(itemIndex);
        if (!this.isLeaf(startingIndex)) {
            decision = itemWeight * ((KPItem)this.getLeaf(itemIndex)).getEfficiency() - profitAccumulated > allowedProfitLoss + 1.0E-4;
            return new SearchInfos(decision, startingIndex, profitAccumulated, weightAccumulated, startItemWeight);
        }
        int index = startingIndex;
        double itemEfficiency = ((KPItem)this.getLeaf(itemIndex)).getEfficiency();
        double profit = profitAccumulated;
        double weight = weightAccumulated;
        double nextWeight = startItemWeight;
        double nextProfit = startItemWeight * ((KPItem)this.getLeaf(startingIndex)).getEfficiency();
        while (profit + nextProfit - (weight + nextWeight) * itemEfficiency >= -allowedProfitLoss) {
            weight += nextWeight;
            profit += nextProfit;
            if ((index = this.getNextNode(index, true)) == -1) {
                decision = weight < itemWeight && itemWeight * itemEfficiency - profit > allowedProfitLoss + 1.0E-4;
                return new SearchInfos(decision, -1, profit, weight, 0.0);
            }
            nextProfit = this.getNodeProfit(index);
            nextWeight = this.getNodeWeight(index);
        }
        while (this.isInnerNode(index)) {
            int leftChild = this.getLeftChild(index);
            nextProfit = this.getNodeProfit(leftChild);
            if (profit + nextProfit - (weight + (nextWeight = (double)this.getNodeWeight(leftChild))) * itemEfficiency <= -allowedProfitLoss) {
                index = leftChild;
                continue;
            }
            weight += nextWeight;
            profit += nextProfit;
            index = this.getRightChild(index);
        }
        double remainingWeightEndItem = 0.0;
        if (!this.isLeaf(index)) {
            decision = itemWeight * itemEfficiency - profit > allowedProfitLoss + 1.0E-4;
        } else {
            double portionWeight = (weight * itemEfficiency - profit - allowedProfitLoss) / (((KPItem)this.getLeaf(index)).getEfficiency() - itemEfficiency);
            profit += portionWeight * ((KPItem)this.getLeaf(index)).getEfficiency();
            remainingWeightEndItem = index == startingIndex ? startItemWeight - portionWeight : (double)this.getNodeWeight(index) - portionWeight;
            boolean bl = decision = (weight += portionWeight) + 1.0E-4 < itemWeight;
            if (Math.abs(weight * itemEfficiency - profit - allowedProfitLoss) > 0.01) {
                throw new RuntimeException("Limit Weight found is not correct");
            }
        }
        return new SearchInfos(decision, index, profit, weight, remainingWeightEndItem);
    }

    public SearchInfos computeLimitWeightForbidden(Info criticalInfos, int itemIndex, int startingIndex, double profitAccumulated, double weightAccumulated, double allowedProfitLoss, double startItemWeight) {
        assert (!this.isInnerNode(startingIndex));
        boolean decision = false;
        double itemWeight = this.getNodeWeight(itemIndex);
        if (!this.isLeaf(startingIndex)) {
            decision = profitAccumulated - itemWeight * ((KPItem)this.getLeaf(itemIndex)).getEfficiency() > allowedProfitLoss + 1.0E-4;
            return new SearchInfos(decision, startingIndex, profitAccumulated, weightAccumulated, startItemWeight);
        }
        int index = startingIndex;
        double itemEfficiency = ((KPItem)this.getLeaf(itemIndex)).getEfficiency();
        double profit = profitAccumulated;
        double weight = weightAccumulated;
        double nextWeight = startItemWeight;
        double nextProfit = startItemWeight * ((KPItem)this.getLeaf(startingIndex)).getEfficiency();
        while ((weight + nextWeight) * itemEfficiency - profit - nextProfit >= -allowedProfitLoss) {
            weight += nextWeight;
            profit += nextProfit;
            if ((index = this.getNextNode(index, false)) == -1) {
                decision = weight < itemWeight && itemWeight * itemEfficiency - profit + 1.0E-4 < allowedProfitLoss;
                return new SearchInfos(decision, -1, profit, weight, 0.0);
            }
            nextProfit = this.getNodeProfit(index);
            nextWeight = this.getNodeWeight(index);
        }
        while (this.isInnerNode(index)) {
            int rightChild = this.getRightChild(index);
            nextProfit = this.getNodeProfit(rightChild);
            nextWeight = this.getNodeWeight(rightChild);
            if ((weight + nextWeight) * itemEfficiency - profit - nextProfit <= -allowedProfitLoss) {
                index = rightChild;
                continue;
            }
            weight += nextWeight;
            profit += nextProfit;
            index = this.getLeftChild(index);
        }
        double remainingWeightEndItem = 0.0;
        if (!this.isLeaf(index)) {
            decision = itemWeight * itemEfficiency - profit + 1.0E-4 < allowedProfitLoss;
        } else {
            double portionWeight = (profit - allowedProfitLoss - weight * itemEfficiency) / (itemEfficiency - ((KPItem)this.getLeaf(index)).getEfficiency());
            profit += portionWeight * ((KPItem)this.getLeaf(index)).getEfficiency();
            remainingWeightEndItem = index == startingIndex ? startItemWeight - portionWeight : (double)this.getNodeWeight(index) - portionWeight;
            boolean bl = decision = (weight += portionWeight) + 1.0E-4 < itemWeight;
            if (Math.abs(profit - weight * itemEfficiency - allowedProfitLoss) > 0.01) {
                throw new RuntimeException("Limit Weight found is not correct");
            }
        }
        return new SearchInfos(decision, index, profit, weight, remainingWeightEndItem);
    }
}

