/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.FastBooleanValidityChecker;
import org.chocosolver.solver.constraints.extension.nary.IterTuplesTable;
import org.chocosolver.solver.constraints.extension.nary.PropLargeCSP;
import org.chocosolver.solver.constraints.extension.nary.RelationFactory;
import org.chocosolver.solver.constraints.extension.nary.ValidityChecker;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableBitSet;

@Explained(ignored=true, comment="Turned into clauses")
public class PropLargeGAC3rmPositive
extends PropLargeCSP<IterTuplesTable> {
    private final int[][] supports;
    private final int arity;
    private final int[] offsets;
    private static final int NO_SUPPORT = -2;
    private final int[][][] tab;
    private final ValidityChecker valcheck;
    private final IntIterableBitSet vrms;

    private PropLargeGAC3rmPositive(IntVar[] vars, IterTuplesTable relation) {
        super(vars, relation);
        this.arity = vars.length;
        this.offsets = new int[this.arity];
        this.supports = new int[this.arity][];
        for (int i = 0; i < this.arity; ++i) {
            this.offsets[i] = vars[i].getLB();
            this.supports[i] = new int[vars[i].getRange()];
        }
        this.tab = relation.getTableLists();
        int[][] tt = relation.getTupleTable();
        boolean fastBooleanValidCheckAllowed = true;
        block1: for (int i = 0; i < tt.length; ++i) {
            for (int j = 0; j < tt[i].length; ++j) {
                int lb = vars[j].getLB();
                int ub = vars[j].getUB();
                if (lb >= 0 && ub <= 1) continue;
                fastBooleanValidCheckAllowed = false;
                break block1;
            }
        }
        this.valcheck = fastBooleanValidCheckAllowed ? new FastBooleanValidityChecker(this.arity, vars) : new ValidityChecker(this.arity, vars);
        this.vrms = new IntIterableBitSet();
    }

    public PropLargeGAC3rmPositive(IntVar[] vars, Tuples tuples) {
        this(vars, RelationFactory.makeIterableRelation(tuples, vars));
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.initSupports();
        for (int indexVar = 0; indexVar < this.arity; ++indexVar) {
            this.reviseVar(indexVar);
        }
    }

    @Override
    public void propagate(int vIdx, int mask) throws ContradictionException {
        this.filter(vIdx);
    }

    private void initSupports() throws ContradictionException {
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            this.vrms.clear();
            this.vrms.setOffset(((IntVar[])this.vars)[i].getLB());
            int ubi = ((IntVar[])this.vars)[i].getUB();
            int val = ((IntVar[])this.vars)[i].getLB();
            while (val <= ubi) {
                int nva = val - ((IterTuplesTable)this.relation).getRelationOffset(i);
                if (this.tab[i][nva].length == 0) {
                    this.vrms.add(val);
                } else {
                    this.setSupport(this.tab[i][nva][0]);
                }
                val = ((IntVar[])this.vars)[i].nextValue(val);
            }
            ((IntVar[])this.vars)[i].removeValues(this.vrms, this);
        }
    }

    private void setSupport(int idxSupport) {
        int[] tuple = ((IterTuplesTable)this.relation).getTuple(idxSupport);
        for (int i = 0; i < tuple.length; ++i) {
            this.supports[i][tuple[i] - this.offsets[i]] = idxSupport;
        }
    }

    private int getSupport(int indexVar, int value) {
        return this.supports[indexVar][value - this.offsets[indexVar]];
    }

    private void reviseVar(int indexVar) throws ContradictionException {
        this.vrms.clear();
        this.vrms.setOffset(((IntVar[])this.vars)[indexVar].getLB());
        int ub = ((IntVar[])this.vars)[indexVar].getUB();
        int val = ((IntVar[])this.vars)[indexVar].getLB();
        while (val <= ub) {
            int nva = val - ((IterTuplesTable)this.relation).getRelationOffset(indexVar);
            int currentIdxSupport = this.getSupport(indexVar, val);
            if (!this.valcheck.isValid(((IterTuplesTable)this.relation).getTuple(currentIdxSupport))) {
                currentIdxSupport = this.seekNextSupport(indexVar, nva);
                if (currentIdxSupport == -2) {
                    this.vrms.add(val);
                } else {
                    this.setSupport(currentIdxSupport);
                }
            }
            val = ((IntVar[])this.vars)[indexVar].nextValue(val);
        }
        ((IntVar[])this.vars)[indexVar].removeValues(this.vrms, this);
    }

    private int seekNextSupport(int indexVar, int nva) {
        for (int i = 0; i < this.tab[indexVar][nva].length; ++i) {
            int currentIdxSupport = this.tab[indexVar][nva][i];
            int[] currentSupport = ((IterTuplesTable)this.relation).getTuple(currentIdxSupport);
            if (!this.valcheck.isValid(currentSupport)) continue;
            return currentIdxSupport;
        }
        return -2;
    }

    private void filter(int idx) throws ContradictionException {
        this.valcheck.sortvars();
        for (int i = 0; i < this.arity; ++i) {
            if (idx == this.valcheck.getPosition(i)) continue;
            this.reviseVar(this.valcheck.getPosition(i));
        }
    }
}

