/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.binary;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.binary.BinRelation;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public abstract class PropBinCSP
extends Propagator<IntVar> {
    protected BinRelation relation;
    protected IntVar v0;
    protected IntVar v1;

    protected PropBinCSP(IntVar x, IntVar y, BinRelation relation) {
        super((Variable[])ArrayUtils.toArray(x, y), (Priority)PropagatorPriority.BINARY, true);
        this.relation = relation;
        this.v0 = x;
        this.v1 = y;
    }

    public final BinRelation getRelation() {
        return this.relation;
    }

    @Override
    public ESat isEntailed() {
        int nbCons = 0;
        int ub0 = ((IntVar[])this.vars)[0].getUB();
        int val0 = ((IntVar[])this.vars)[0].getLB();
        while (val0 <= ub0) {
            int nbS = 0;
            int ub1 = ((IntVar[])this.vars)[1].getUB();
            int val1 = ((IntVar[])this.vars)[1].getLB();
            while (val1 <= ub1) {
                if (this.relation.isConsistent(val0, val1)) {
                    ++nbS;
                }
                val1 = ((IntVar[])this.vars)[1].nextValue(val1);
            }
            if (nbS > 0 && nbS < ((IntVar[])this.vars)[1].getDomainSize()) {
                return ESat.UNDEFINED;
            }
            nbCons += nbS;
            val0 = ((IntVar[])this.vars)[0].nextValue(val0);
        }
        if (nbCons == 0) {
            return ESat.FALSE;
        }
        if (nbCons == ((IntVar[])this.vars)[0].getDomainSize() * ((IntVar[])this.vars)[1].getDomainSize()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    public Tuples extractTuples() {
        return this.relation.convert();
    }
}

