## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----echo = FALSE-------------------------------------------------------------
library(devtools)
load_all()

## ----eval = FALSE-------------------------------------------------------------
# library(puff)

## -----------------------------------------------------------------------------
set.seed(123)

sim_dt <- 10
puff_dt <- 10
output_dt <- 60

start_time <- "2024-01-01 12:00:00"
end_time <- "2024-01-01 13:00:00"

source_coords <- c(0, 0, 2.5)
sensor_coords <- matrix(c(-6.525403221327715e-15, -35.52264, 2.01775), ncol = 3, byrow = TRUE)

emission_rate <- 3.5

wind_data <- data.frame(
  wind_u = runif(3601, min = -3, max = 0.7),
  wind_v = runif(3601, min = -3, max = 1.5)
)

out <- out <- simulate_sensor_mode(
  start_time, end_time, 
  source_coords, emission_rate,
  wind_data, 
  sensor_coords,
  sim_dt, puff_dt, output_dt, 
  puff_duration = 1200
)

## -----------------------------------------------------------------------------
head(out)

## -----------------------------------------------------------------------------
out |> 
  dplyr::rename(time = Group.1,
                sensor_1_concentration = Sensor_1) |> 
  head()

## ----fig.align='center', out.width='100%', fig.width=12, fig.height=8---------
time_series_plot(out)

## ----fig.align='center', out.width='100%', fig.width=12, fig.height=15--------
faceted_time_series_plot(out, 
                         sensor_coords,
                         wind_data, 
                         as.POSIXct(start_time), 
                         as.POSIXct(end_time), 
                         output_dt)

## ----fig.align='center', out.width='100%', fig.width=12, fig.height=8---------
create_site_map(sensor_coords,
                source_coords)

## ----echo = TRUE, eval = FALSE------------------------------------------------
# set.seed(123)
# 
# sim_dt <- 2
# puff_dt <- 2
# output_dt <- 60
# start_time <- "2024-01-01 12:00:00"
# end_time <- "2024-01-01 13:00:00"
# source_coords <- c(0, 0, 2.5)
# emission_rate <- 5
# wind_data <- data.frame(
#     wind_u = runif(3601, min = -2, max = 0.7),
#     wind_v = runif(3601, min = -2, max = 1.5)
# )
# 
# grid_coords <- list(
#   x = seq(-2, 2, by = 1),
#   y = seq(-2, 2, by = 1),
#   z = c(2.5)
# )
# 
# 
# out <- simulate_grid_mode(
#   start_time = start_time,
#   end_time = end_time,
#   source_coords = source_coords,
#   emission_rate = emission_rate,
#   wind_data = wind_data,
#   grid_coords = grid_coords,
#   sim_dt = sim_dt,
#   puff_dt = puff_dt,
#   output_dt = output_dt,
#   puff_duration = 1200
#   )
# 
# plot_2d_animated(
#   out, grid_coords,
#   start_time, end_time, output_dt,
#   frames = 200,
#   transition = 199,
#   interpolate_grid = TRUE
#   )

