/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor;

import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import weka.classifiers.EnsembleLibraryModel;
import weka.classifiers.EnsembleLibraryModelComparator;

public class ModelList
extends JList {
    private static final long serialVersionUID = -421567241792939539L;

    public ModelList() {
        this.setModel(new SortedListModel());
        this.setCellRenderer(new ModelListRenderer());
    }

    public class SortedListModel
    extends AbstractListModel {
        private static final long serialVersionUID = -8334675481243839371L;
        SortedSet m_Models = new TreeSet(new EnsembleLibraryModelComparator());

        public int getSize() {
            return this.m_Models.size();
        }

        public Object getElementAt(int n) {
            return this.m_Models.toArray()[n];
        }

        public void add(Object object) {
            if (this.m_Models.add(object)) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
        }

        public void addAll(Object[] objectArray) {
            List<Object> list = Arrays.asList(objectArray);
            this.m_Models.addAll(list);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void clear() {
            this.m_Models.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public boolean contains(Object object) {
            return this.m_Models.contains(object);
        }

        public Object firstElement() {
            return this.m_Models.first();
        }

        public Iterator iterator() {
            return this.m_Models.iterator();
        }

        public Object lastElement() {
            return this.m_Models.last();
        }

        public boolean removeElement(Object object) {
            boolean bl = this.m_Models.remove(object);
            if (bl) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
            return bl;
        }
    }

    public class ModelListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -7061163240718897794L;

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = null;
            if (object instanceof EnsembleLibraryModel) {
                EnsembleLibraryModel ensembleLibraryModel = (EnsembleLibraryModel)object;
                String string = n + ": " + ensembleLibraryModel.getStringRepresentation().replaceAll("weka.classifiers.", "");
                component = super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
                if (!ensembleLibraryModel.getOptionsWereValid()) {
                    component.setBackground(Color.pink);
                }
                ((JComponent)component).setToolTipText(ensembleLibraryModel.getDescriptionText());
            }
            return component;
        }
    }
}

