/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.uuid;

import com.hp.hpl.jena.shared.uuid.UUID;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

class UUID_V4
extends UUID {
    static final int versionHere = 4;
    static final int variantHere = 2;
    static Random random = null;
    static boolean initialized = false;
    static boolean warningSent = false;

    UUID_V4() {
        super(4, 2);
        UUID_V4.init();
        byte[] b = new byte[16];
        random.nextBytes(b);
        b[6] = (byte)(b[6] & 0xF);
        b[6] = (byte)(b[6] | 0x40);
        b[8] = (byte)(b[8] & 0x3F);
        b[8] = (byte)(b[8] | 0x80);
        StringBuffer sb = new StringBuffer(40);
        String tmp = UUID.stringify(b);
        sb.append(tmp.substring(0, 8));
        sb.append('-');
        sb.append(tmp.substring(8, 12));
        sb.append('-');
        sb.append(tmp.substring(12, 16));
        sb.append('-');
        sb.append(tmp.substring(16, 20));
        sb.append('-');
        sb.append(tmp.substring(20));
        this.uuid = sb.toString();
    }

    UUID_V4(String s) {
        super(4, 2);
        if (s.equals("00000000-0000-0000-0000-000000000000")) {
            this.uuid = "00000000-0000-0000-0000-000000000000";
            return;
        }
        try {
            int var = Integer.parseInt(s.substring(19, 20), 16);
            if ((var >>= 2) != 2) {
                throw new UUID.FormatException("UUID variant is not 2: " + var + " in " + s);
            }
            String tmp = s.substring(14, 15);
            int version = Integer.parseInt(tmp, 16);
            int ver = Integer.parseInt(s.substring(14, 15), 16);
            if (ver != 4) {
                throw new UUID.FormatException("UUID version is strange: " + ver + " in " + s);
            }
        }
        catch (NumberFormatException e) {
            throw new UUID.FormatException("UUID has unknown variant or version: " + s);
        }
        this.uuid = s;
    }

    public static void init() {
        if (!initialized) {
            UUID_V4.reset();
            initialized = true;
        }
    }

    public static void uninit() {
        initialized = false;
    }

    public static void reset() {
        block5: {
            random = null;
            if (useSecureRandom) {
                try {
                    SecureRandom sRandom = SecureRandom.getInstance("SHA1PRNG");
                    random = sRandom;
                }
                catch (NoSuchAlgorithmException ex) {
                    if (warningSent) break block5;
                    System.err.println("No secure random generator.");
                    warningSent = true;
                }
            }
        }
        byte[] seed = UUID_V4.makeSeed();
        if (random == null) {
            random = new Random();
            long l = 0L;
            for (int i = 0; i < 8; ++i) {
                l = l << 8 | (long)(seed[i] & 0xFF);
            }
            random = new Random();
            random.setSeed(l);
        }
    }
}

