/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPBRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPRuleStore;
import com.hp.hpl.jena.util.OneToManyMap;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FBLPRuleInfGraph
extends FBRuleInfGraph {
    protected LPBRuleEngine lpbEngine;
    static Log logger = LogFactory.getLog((Class)FBLPRuleInfGraph.class);

    public FBLPRuleInfGraph(Reasoner reasoner, Graph schema) {
        super(reasoner, schema);
        this.initLP(schema);
    }

    public FBLPRuleInfGraph(Reasoner reasoner, List rules, Graph schema) {
        super(reasoner, rules, schema);
        this.initLP(schema);
    }

    public FBLPRuleInfGraph(Reasoner reasoner, List rules, Graph schema, Graph data) {
        super(reasoner, rules, schema, data);
        this.initLP(schema);
    }

    private void initLP(Graph schema) {
        if (schema != null && schema instanceof FBLPRuleInfGraph) {
            LPRuleStore newStore = new LPRuleStore();
            newStore.addAll(((FBLPRuleInfGraph)schema).lpbEngine.getRuleStore());
            this.lpbEngine = new LPBRuleEngine(this, newStore);
        } else {
            this.lpbEngine = new LPBRuleEngine(this);
        }
    }

    public boolean processBuiltin(Object clause, Rule rule, BindingEnvironment env) {
        throw new ReasonerException("Internal error in FBLP rule engine, incorrect invocation of building in rule " + rule);
    }

    public void addBRule(Rule brule) {
        this.lpbEngine.addRule(brule);
        this.lpbEngine.reset();
    }

    public void deleteBRule(Rule brule) {
        this.lpbEngine.deleteRule(brule);
        this.lpbEngine.reset();
    }

    public void addBRules(List rules) {
        Iterator i = rules.iterator();
        while (i.hasNext()) {
            Rule rule = (Rule)i.next();
            this.lpbEngine.addRule(rule);
        }
        this.lpbEngine.reset();
    }

    public List getBRules() {
        return this.lpbEngine.getAllRules();
    }

    public void setTabled(Node predicate) {
        this.lpbEngine.tablePredicate(predicate);
        if (this.traceOn) {
            logger.info((Object)("LP TABLE " + predicate));
        }
    }

    public void rebind() {
        if (this.lpbEngine != null) {
            this.lpbEngine.reset();
        }
        this.isPrepared = false;
    }

    public void setTraceOn(boolean state) {
        super.setTraceOn(state);
        this.lpbEngine.setTraceOn(state);
    }

    public void setDerivationLogging(boolean recordDerivations) {
        this.recordDerivations = recordDerivations;
        this.engine.setDerivationLogging(recordDerivations);
        this.lpbEngine.setDerivationLogging(recordDerivations);
        this.derivations = recordDerivations ? new OneToManyMap() : null;
    }

    public long getNRulesFired() {
        return this.engine.getNRulesFired();
    }

    public ExtendedIterator findWithContinuation(TriplePattern pattern, Finder continuation) {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        ExtendedIterator result = new UniqueExtendedIterator(this.lpbEngine.find(pattern));
        if (continuation != null) {
            result = result.andThen(continuation.find(pattern));
        }
        return result.filterDrop(Functor.acceptFilter);
    }

    public void reset() {
        this.lpbEngine.reset();
        this.isPrepared = false;
    }

    public synchronized void performAdd(Triple t) {
        this.fdata.getGraph().add(t);
        if (this.useTGCCaching && this.transitiveEngine.add(t)) {
            this.isPrepared = false;
        }
        if (this.isPrepared) {
            this.engine.add(t);
        }
        this.lpbEngine.reset();
    }

    public void performDelete(Triple t) {
        this.fdata.getGraph().delete(t);
        if (this.useTGCCaching && this.transitiveEngine.delete(t)) {
            if (this.isPrepared) {
                this.bEngine.deleteAllRules();
            }
            this.isPrepared = false;
        }
        if (this.isPrepared) {
            this.getDeductionsGraph().delete(t);
            this.engine.delete(t);
        }
        this.lpbEngine.reset();
    }

    public void resetLPProfile(boolean enable) {
        this.lpbEngine.resetProfile(enable);
    }

    public void printLPProfile() {
        this.lpbEngine.printProfile();
    }
}

