/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLCommon;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLProperty;
import com.hp.hpl.jena.ontology.daml.LiteralAccessor;
import com.hp.hpl.jena.ontology.daml.PropertyAccessor;
import com.hp.hpl.jena.ontology.daml.impl.DAMLCommonImpl;
import com.hp.hpl.jena.ontology.daml.impl.PropertyAccessorImpl;
import com.hp.hpl.jena.ontology.daml.impl.VocabularyManager;
import com.hp.hpl.jena.ontology.impl.OntPropertyImpl;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ConcatenatedIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.DAMLVocabulary;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;

public class DAMLPropertyImpl
extends OntPropertyImpl
implements DAMLProperty {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new DAMLPropertyImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n.toString() + " to DAMLProperty");
        }

        public boolean canWrap(Node node, EnhGraph eg) {
            return DAMLPropertyImpl.hasType(node, eg, DAML_OIL.Property) || DAMLPropertyImpl.hasType(node, eg, DAML_OIL.DatatypeProperty) || DAMLPropertyImpl.hasType(node, eg, DAML_OIL.ObjectProperty);
        }
    };
    private DAMLVocabulary m_vocabulary = VocabularyManager.getDefaultVocabulary();
    private PropertyAccessor m_propDomain = new PropertyAccessorImpl(this.getVocabulary().domain(), this);
    private PropertyAccessor m_propRange = new PropertyAccessorImpl(this.getVocabulary().range(), this);
    private PropertyAccessor m_propSubPropertyOf = new PropertyAccessorImpl(this.getVocabulary().subPropertyOf(), this);
    private PropertyAccessor m_propSamePropertyAs = new PropertyAccessorImpl(this.getVocabulary().samePropertyAs(), this);
    private DAMLCommon m_common = null;

    public DAMLPropertyImpl(Node n, EnhGraph g) {
        super(n, g);
        this.m_common = new DAMLCommonImpl(n, g);
    }

    public void setRDFType(Resource rdfClass, boolean replace) {
        this.m_common.setRDFType(rdfClass, replace);
    }

    public DAMLModel getDAMLModel() {
        return this.m_common.getDAMLModel();
    }

    public ExtendedIterator getRDFTypes(boolean complete) {
        return this.m_common.getRDFTypes(complete);
    }

    public DAMLVocabulary getVocabulary() {
        return this.m_vocabulary;
    }

    public LiteralAccessor prop_label() {
        return this.m_common.prop_label();
    }

    public LiteralAccessor prop_comment() {
        return this.m_common.prop_comment();
    }

    public PropertyAccessor prop_equivalentTo() {
        return this.m_common.prop_equivalentTo();
    }

    public PropertyAccessor prop_type() {
        return this.m_common.prop_type();
    }

    public ExtendedIterator getEquivalentValues() {
        ConcatenatedIterator i = new ConcatenatedIterator(this.m_common.getEquivalentValues(), this.getSameProperties());
        return UniqueExtendedIterator.create(i).mapWith(new OntResourceImpl.AsMapper(DAMLProperty.class));
    }

    public ExtendedIterator getEquivalenceSet() {
        HashSet<DAMLPropertyImpl> s = new HashSet<DAMLPropertyImpl>();
        s.add(this);
        ExtendedIterator i = this.getEquivalentValues();
        while (i.hasNext()) {
            s.add((DAMLPropertyImpl)i.next());
        }
        s.remove(this);
        return WrappedIterator.create(s.iterator());
    }

    public void setIsUnique(boolean unique) {
        if (unique) {
            this.addRDFType(this.getVocabulary().UniqueProperty());
        } else {
            this.removeProperty(RDF.type, this.getVocabulary().UniqueProperty());
        }
    }

    public boolean isUnique() {
        return this.hasRDFType(this.getVocabulary().UniqueProperty());
    }

    public PropertyAccessor prop_domain() {
        return this.m_propDomain;
    }

    public PropertyAccessor prop_subPropertyOf() {
        return this.m_propSubPropertyOf;
    }

    public PropertyAccessor prop_samePropertyAs() {
        return this.m_propSamePropertyAs;
    }

    public PropertyAccessor prop_range() {
        return this.m_propRange;
    }

    public ExtendedIterator getSameProperties() {
        return WrappedIterator.create(super.listEquivalentProperties()).mapWith(new OntResourceImpl.AsMapper(DAMLProperty.class));
    }

    public ExtendedIterator getSuperProperties() {
        return this.getSuperProperties(true);
    }

    public ExtendedIterator getSuperProperties(boolean closed) {
        return WrappedIterator.create(this.listSuperProperties(!closed)).mapWith(new OntResourceImpl.AsMapper(DAMLProperty.class));
    }

    public ExtendedIterator getSubProperties() {
        return this.getSubProperties(true);
    }

    public ExtendedIterator getSubProperties(boolean closed) {
        return WrappedIterator.create(this.listSubProperties(!closed)).mapWith(new OntResourceImpl.AsMapper(DAMLProperty.class));
    }

    public ExtendedIterator getDomainClasses() {
        return WrappedIterator.create(this.listPropertyValues(this.getProfile().DOMAIN())).mapWith(new OntResourceImpl.AsMapper(DAMLClass.class));
    }

    public ExtendedIterator getRangeClasses() {
        return WrappedIterator.create(this.listPropertyValues(this.getProfile().RANGE())).mapWith(new OntResourceImpl.AsMapper(DAMLClass.class));
    }
}

