/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SimpleBulkUpdateHandler
implements BulkUpdateHandler {
    protected GraphWithPerform graph;
    protected GraphEventManager manager;

    public SimpleBulkUpdateHandler(GraphWithPerform graph) {
        this.graph = graph;
        this.manager = graph.getEventManager();
    }

    public void add(Triple[] triples) {
        for (int i = 0; i < triples.length; ++i) {
            this.graph.performAdd(triples[i]);
        }
        this.manager.notifyAddArray(this.graph, triples);
    }

    public void add(List triples) {
        this.add(triples, true);
    }

    protected void add(List triples, boolean notify) {
        for (int i = 0; i < triples.size(); ++i) {
            this.graph.performAdd((Triple)triples.get(i));
        }
        if (notify) {
            this.manager.notifyAddList(this.graph, triples);
        }
    }

    public void add(Iterator it) {
        this.addIterator(it, true);
    }

    public void addIterator(Iterator it, boolean notify) {
        List s = IteratorCollection.iteratorToList(it);
        this.add(s, false);
        if (notify) {
            this.manager.notifyAddIterator((Graph)this.graph, s);
        }
    }

    public void add(Graph g) {
        this.add(g, false);
    }

    public void add(Graph g, boolean withReifications) {
        this.addIterator(GraphUtil.findAll(g), false);
        if (withReifications) {
            SimpleBulkUpdateHandler.addReifications(this.graph, g);
        }
        this.manager.notifyAddGraph(this.graph, g);
    }

    public static void addReifications(Graph ours, Graph g) {
        Reifier r = g.getReifier();
        ExtendedIterator it = r.allNodes();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            ours.getReifier().reifyAs(node, r.getTriple(node));
        }
    }

    public static void deleteReifications(Graph ours, Graph g) {
        Reifier r = g.getReifier();
        ExtendedIterator it = r.allNodes();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            ours.getReifier().remove(node, r.getTriple(node));
        }
    }

    public void delete(Triple[] triples) {
        for (int i = 0; i < triples.length; ++i) {
            this.graph.performDelete(triples[i]);
        }
        this.manager.notifyDeleteArray(this.graph, triples);
    }

    public void delete(List triples) {
        this.delete(triples, true);
    }

    protected void delete(List triples, boolean notify) {
        for (int i = 0; i < triples.size(); ++i) {
            this.graph.performDelete((Triple)triples.get(i));
        }
        if (notify) {
            this.manager.notifyDeleteList(this.graph, triples);
        }
    }

    public void delete(Iterator it) {
        this.deleteIterator(it, true);
    }

    public void deleteIterator(Iterator it, boolean notify) {
        List L = IteratorCollection.iteratorToList(it);
        this.delete(L, false);
        if (notify) {
            this.manager.notifyDeleteIterator((Graph)this.graph, L);
        }
    }

    private List triplesOf(Graph g) {
        ArrayList L = new ArrayList();
        ExtendedIterator it = g.find(Triple.ANY);
        while (it.hasNext()) {
            L.add(it.next());
        }
        return L;
    }

    public void delete(Graph g) {
        this.delete(g, false);
    }

    public void delete(Graph g, boolean withReifications) {
        if (g.dependsOn(this.graph)) {
            this.delete(this.triplesOf(g));
        } else {
            this.deleteIterator(GraphUtil.findAll(g), false);
        }
        if (withReifications) {
            SimpleBulkUpdateHandler.deleteReifications(this.graph, g);
        }
        this.manager.notifyDeleteGraph(this.graph, g);
    }

    public void removeAll() {
        SimpleBulkUpdateHandler.removeAll(this.graph);
        this.notifyRemoveAll();
    }

    protected void notifyRemoveAll() {
        this.manager.notifyEvent(this.graph, GraphEvents.removeAll);
    }

    public void remove(Node s, Node p, Node o) {
        SimpleBulkUpdateHandler.removeAll(this.graph, s, p, o);
        this.manager.notifyEvent(this.graph, GraphEvents.remove(s, p, o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAll(Graph g, Node s, Node p, Node o) {
        ExtendedIterator it = g.find(s, p, o);
        try {
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
        }
        finally {
            it.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAll(Graph g) {
        ExtendedIterator it = GraphUtil.findAll(g);
        try {
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
        }
        finally {
            it.close();
        }
    }
}

