/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.NodeCache;
import com.hp.hpl.jena.graph.NodeVisitor;
import com.hp.hpl.jena.graph.Node_ANY;
import com.hp.hpl.jena.graph.Node_Blank;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Node_NULL;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;

public abstract class Node {
    protected final Object label;
    static final int THRESHOLD = 10000;
    static final NodeCache present = new NodeCache();
    public static final Node ANY = new Node_ANY();
    static final String RDFprefix = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    static final NodeMaker makeAnon = new NodeMaker(){

        Node construct(Object x) {
            return new Node_Blank(x);
        }
    };
    static final NodeMaker makeLiteral = new NodeMaker(){

        Node construct(Object x) {
            return new Node_Literal(x);
        }
    };
    static final NodeMaker makeURI = new NodeMaker(){

        Node construct(Object x) {
            return new Node_URI(x);
        }
    };
    static final NodeMaker makeVariable = new NodeMaker(){

        Node construct(Object x) {
            return new Node_Variable(x);
        }
    };
    public static final Node NULL = new Node_NULL();
    private static boolean caching = true;

    public static Node create(String x) {
        return Node.create(PrefixMapping.Extended, x);
    }

    public static Node create(PrefixMapping pm, String x) {
        if (x.equals("")) {
            throw new JenaException("Node.create does not accept an empty string as argument");
        }
        char first = x.charAt(0);
        if (first == '\'' || first == '\"') {
            return Node.createLiteral(Node.newString(pm, first, x));
        }
        if (Character.isDigit(first)) {
            return Node.createLiteral(x, "", XSDDatatype.XSDinteger);
        }
        if (first == '_') {
            return Node.createAnon(new AnonId(x));
        }
        if (x.equals("??")) {
            return ANY;
        }
        if (first == '?') {
            return Node.createVariable(x.substring(1));
        }
        if (first == '&') {
            return Node.createURI("q:" + x.substring(1));
        }
        int colon = x.indexOf(58);
        String d = pm.getNsPrefixURI("");
        return colon < 0 ? Node.createURI((d == null ? "eh:/" : d) + x) : Node.createURI(pm.expandPrefix(x));
    }

    private static RDFDatatype getType(String s) {
        return TypeMapper.getInstance().getSafeTypeByName(s);
    }

    private static LiteralLabel literal(PrefixMapping pm, String spelling, String langOrType) {
        String content = Node.unEscape(spelling);
        int colon = langOrType.indexOf(58);
        return colon < 0 ? new LiteralLabel(content, langOrType, false) : LiteralLabel.createLiteralLabel(content, "", Node.getType(pm.expandPrefix(langOrType)));
    }

    private static String unEscape(String spelling) {
        int b;
        if (spelling.indexOf(92) < 0) {
            return spelling;
        }
        StringBuffer result = new StringBuffer(spelling.length());
        int start = 0;
        while ((b = spelling.indexOf(92, start)) >= 0) {
            result.append(spelling.substring(start, b));
            result.append(Node.unEscape(spelling.charAt(b + 1)));
            start = b + 2;
        }
        result.append(spelling.substring(start));
        return result.toString();
    }

    private static char unEscape(char ch) {
        switch (ch) {
            case '\"': 
            case '\'': 
            case '\\': {
                return ch;
            }
            case 'n': {
                return '\n';
            }
            case 's': {
                return ' ';
            }
            case 't': {
                return '\t';
            }
        }
        return 'Z';
    }

    private static LiteralLabel newString(PrefixMapping pm, char quote, String nodeString) {
        int close = nodeString.lastIndexOf(quote);
        return Node.literal(pm, nodeString.substring(1, close), nodeString.substring(close + 1));
    }

    public static Node createAnon() {
        return Node.createAnon(AnonId.create());
    }

    public static Node createAnon(AnonId id) {
        return Node.create(makeAnon, id);
    }

    public static Node createLiteral(LiteralLabel lit) {
        return Node.create(makeLiteral, lit);
    }

    public static Node createURI(String uri) {
        return Node.create(makeURI, (Object)uri);
    }

    public static Node createVariable(String name) {
        return Node.create(makeVariable, Node_Variable.variable(name));
    }

    public static Node createLiteral(String value) {
        return Node.createLiteral(value, "", false);
    }

    public static Node createLiteral(String lit, String lang, boolean isXml) {
        if (lit == null) {
            throw new NullPointerException("null for literals has been illegal since Jena 2.0");
        }
        return Node.createLiteral(new LiteralLabel(lit, lang, isXml));
    }

    public static Node createLiteral(String lex, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        return Node.createLiteral(LiteralLabel.createLiteralLabel(lex, lang, dtype));
    }

    public static Node createUncachedLiteral(Object value, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        return new Node_Literal(new LiteralLabel(value, lang, dtype));
    }

    public abstract Object visitWith(NodeVisitor var1);

    public abstract boolean isConcrete();

    public boolean isLiteral() {
        return false;
    }

    public boolean isBlank() {
        return false;
    }

    public boolean isURI() {
        return false;
    }

    public boolean isVariable() {
        return false;
    }

    public AnonId getBlankNodeId() {
        throw new UnsupportedOperationException(this + " is not a blank node");
    }

    public String getBlankNodeLabel() {
        return this.getBlankNodeId().getLabelString();
    }

    public LiteralLabel getLiteral() {
        throw new UnsupportedOperationException(this + " is not a literal node");
    }

    public Object getLiteralValue() {
        throw new NotLiteral(this);
    }

    public String getLiteralLexicalForm() {
        throw new NotLiteral(this);
    }

    public String getLiteralLanguage() {
        throw new NotLiteral(this);
    }

    public String getLiteralDatatypeURI() {
        throw new NotLiteral(this);
    }

    public RDFDatatype getLiteralDatatype() {
        throw new NotLiteral(this);
    }

    public boolean getLiteralIsXML() {
        throw new NotLiteral(this);
    }

    public Object getIndexingValue() {
        return this;
    }

    public String getURI() {
        throw new UnsupportedOperationException(this + " is not a URI node");
    }

    public String getNameSpace() {
        throw new UnsupportedOperationException(this + " is not a URI node");
    }

    public String getLocalName() {
        throw new UnsupportedOperationException(this + " is not a URI node");
    }

    public String getName() {
        throw new UnsupportedOperationException("this (" + this.getClass() + ") is not a variable node");
    }

    public boolean hasURI(String uri) {
        return false;
    }

    Node(Object label) {
        this.label = label;
    }

    public static void cache(boolean wantCache) {
        if (!wantCache) {
            present.clear();
        }
        caching = wantCache;
    }

    public static synchronized Node create(NodeMaker maker, Object label) {
        if (label == null) {
            throw new JenaException("Node.make: null label");
        }
        Node node = present.get(label);
        return node == null ? Node.cacheNewNode(label, maker.construct(label)) : node;
    }

    private static Node cacheNewNode(Object label, Node n) {
        if (present.size() > 10000) {
            present.clear();
        }
        if (caching) {
            present.put(label, n);
        }
        return n;
    }

    public abstract boolean equals(Object var1);

    public boolean sameValueAs(Object o) {
        return this.equals(o);
    }

    public int hashCode() {
        return this.label.hashCode() * 31;
    }

    public boolean matches(Node other) {
        return this.equals(other);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(boolean quoting) {
        return this.toString(null, quoting);
    }

    public String toString(PrefixMapping pm) {
        return this.toString(pm, true);
    }

    public String toString(PrefixMapping pm, boolean quoting) {
        return this.label.toString();
    }

    static abstract class NodeMaker {
        NodeMaker() {
        }

        abstract Node construct(Object var1);
    }

    public static class NotLiteral
    extends JenaException {
        public NotLiteral(Node it) {
            super(it + " is not a literal node");
        }
    }
}

