## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, fig.width = 4.8, fig.height = 4.8)

## -----------------------------------------------------------------------------
library(MDCcure)

## -----------------------------------------------------------------------------
set.seed(123)
X <- matrix(rnorm(10 * 2), 10, 2)
Y <- matrix(rnorm(10 * 2), 10, 2)

mdc(X, Y, center = "U")
mdc(X, Y, center = "D")

## -----------------------------------------------------------------------------
set.seed(123)
X <- matrix(rnorm(10 * 2), 10, 2)
Y <- matrix(rnorm(10 * 2), 10, 2)
Z <- matrix(rnorm(10 * 2), 10, 2)

pmdd(X, Y, Z)
pmdc(X, Y, Z)

## ----fig.width=6.5, fig.height=3.5, fig.align='center'------------------------
set.seed(1234)

theta0 = c(1,1)
gamma0 = 0.5
gamma1 = 0.5

cT = 0

n <- 200
maxT = 0.02*n

X = runif(n,-1,1)
Z = runif(n,-1,1)
phi = exp(theta0[1]+theta0[2]*X)
phi = phi/(1+phi)   
B = (runif(n) <= phi)

aT = (X+1)^cT
lambdaX = exp(gamma0+gamma1*X)
bT = lambdaX^(-1/aT)
tau = qweibull(0.9,shape=mean(aT),scale=mean(bT))
Y = rep(100000,n)
count = 0
for (j in 1:n)
{if (B[j]==1)
{stop = 0
while (stop==0)  
{Y[j] = rweibull(1,shape=aT[j],scale=bT[j])
if ((Y[j] > tau)*(count <= maxT)) 
{Y[j] = tau
count = count + 1}
if (Y[j] <= tau) stop = 1}}}

aC = 1
bC = 1.5
C = rweibull(n,shape=aC,scale=bC)
C = replace(C,C>tau,tau+0.001)  

T = apply(cbind(Y,C),1,min)
Delta = as.numeric(Y <= C)

#Covariate hypothesis test for the cure rate with one covariate
testcov(X, T, Delta, method = "All", P = 499)

#Covariate hypothesis test for the cure rate with two covariates
testcov2(X, T, Z, Delta, P = 499)
testcov2(Z, T, X, Delta, P = 499)

#Goodness-of-fit test for the cure rate 
goft(X, T, Delta, model = "logit")
# plotCure(X, T, Delta, density = FALSE)

## ----plotCure-figure, echo=FALSE, out.width='75%', fig.align='center'---------
knitr::include_graphics("Figures/Estimated_cure.pdf")

