/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.ref;

import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.Former;
import cern.colt.matrix.FormerFactory;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.algo.FloatFormatter;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix3D;
import hep.aida.tfloat.FloatIAxis;
import hep.aida.tfloat.FloatIHistogram1D;
import hep.aida.tfloat.FloatIHistogram2D;
import hep.aida.tfloat.FloatIHistogram3D;
import hep.aida.tfloat.bin.FloatBinFunction1D;
import hep.aida.tfloat.bin.FloatBinFunctions1D;

public class FloatConverter {
    public float[] edges(FloatIAxis floatIAxis) {
        int n = floatIAxis.bins();
        float[] fArray = new float[n + 1];
        for (int i = 0; i < n; ++i) {
            fArray[i] = floatIAxis.binLowerEdge(i);
        }
        fArray[n] = floatIAxis.upperEdge();
        return fArray;
    }

    String form(Former former, float f) {
        return former.form(f);
    }

    protected float[] toArrayErrors(FloatIHistogram1D floatIHistogram1D) {
        int n = floatIHistogram1D.xAxis().bins();
        float[] fArray = new float[n];
        int n2 = n;
        while (--n2 >= 0) {
            fArray[n2] = floatIHistogram1D.binError(n2);
        }
        return fArray;
    }

    protected float[][] toArrayErrors(FloatIHistogram2D floatIHistogram2D) {
        int n = floatIHistogram2D.xAxis().bins();
        int n2 = floatIHistogram2D.yAxis().bins();
        float[][] fArray = new float[n][n2];
        int n3 = n2;
        while (--n3 >= 0) {
            int n4 = n;
            while (--n4 >= 0) {
                fArray[n4][n3] = floatIHistogram2D.binError(n4, n3);
            }
        }
        return fArray;
    }

    protected float[] toArrayHeights(FloatIHistogram1D floatIHistogram1D) {
        int n = floatIHistogram1D.xAxis().bins();
        float[] fArray = new float[n];
        int n2 = n;
        while (--n2 >= 0) {
            fArray[n2] = floatIHistogram1D.binHeight(n2);
        }
        return fArray;
    }

    protected float[][] toArrayHeights(FloatIHistogram2D floatIHistogram2D) {
        int n = floatIHistogram2D.xAxis().bins();
        int n2 = floatIHistogram2D.yAxis().bins();
        float[][] fArray = new float[n][n2];
        int n3 = n2;
        while (--n3 >= 0) {
            int n4 = n;
            while (--n4 >= 0) {
                fArray[n4][n3] = floatIHistogram2D.binHeight(n4, n3);
            }
        }
        return fArray;
    }

    protected float[][][] toArrayHeights(FloatIHistogram3D floatIHistogram3D) {
        int n = floatIHistogram3D.xAxis().bins();
        int n2 = floatIHistogram3D.yAxis().bins();
        int n3 = floatIHistogram3D.zAxis().bins();
        float[][][] fArray = new float[n][n2][n3];
        int n4 = n;
        while (--n4 >= 0) {
            int n5 = n2;
            while (--n5 >= 0) {
                int n6 = n3;
                while (--n6 >= 0) {
                    fArray[n4][n5][n6] = floatIHistogram3D.binHeight(n4, n5, n6);
                }
            }
        }
        return fArray;
    }

    protected static String toString(float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = fArray.length - 1;
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(fArray[i]);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toString(FloatIAxis floatIAxis) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Range: [" + floatIAxis.lowerEdge() + "," + floatIAxis.upperEdge() + ")");
        stringBuffer.append(", Bins: " + floatIAxis.bins());
        stringBuffer.append(", Bin edges: " + FloatConverter.toString(this.edges(floatIAxis)) + "\n");
        return stringBuffer.toString();
    }

    public String toString(FloatIHistogram1D floatIHistogram1D) {
        String string = null;
        String string2 = null;
        FloatBinFunction1D[] floatBinFunction1DArray = null;
        String string3 = "%G";
        Former former = new FormerFactory().create(string3);
        String string4 = System.getProperty("line.separator");
        int[] nArray = floatIHistogram1D.minMaxBins();
        String string5 = floatIHistogram1D.title() + ":" + string4 + "   Entries=" + this.form(former, floatIHistogram1D.entries()) + ", ExtraEntries=" + this.form(former, floatIHistogram1D.extraEntries()) + string4 + "   Mean=" + this.form(former, floatIHistogram1D.mean()) + ", Rms=" + this.form(former, floatIHistogram1D.rms()) + string4 + "   MinBinHeight=" + this.form(former, floatIHistogram1D.binHeight(nArray[0])) + ", MaxBinHeight=" + this.form(former, floatIHistogram1D.binHeight(nArray[1])) + string4 + "   Axis: " + "Bins=" + this.form(former, floatIHistogram1D.xAxis().bins()) + ", Min=" + this.form(former, floatIHistogram1D.xAxis().lowerEdge()) + ", Max=" + this.form(former, floatIHistogram1D.xAxis().upperEdge());
        String[] stringArray = new String[floatIHistogram1D.xAxis().bins()];
        for (int i = 0; i < floatIHistogram1D.xAxis().bins(); ++i) {
            stringArray[i] = this.form(former, floatIHistogram1D.xAxis().binLowerEdge(i));
        }
        String[] stringArray2 = null;
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(1, floatIHistogram1D.xAxis().bins());
        denseFloatMatrix2D.viewRow(0).assign(this.toArrayHeights(floatIHistogram1D));
        return string5 + string4 + "Heights:" + string4 + new FloatFormatter().toTitleString(denseFloatMatrix2D, stringArray2, stringArray, string2, string, null, floatBinFunction1DArray);
    }

    public String toString(FloatIHistogram2D floatIHistogram2D) {
        String string = "X";
        String string2 = "Y";
        FloatBinFunction1D[] floatBinFunction1DArray = new FloatBinFunction1D[]{FloatBinFunctions1D.sum};
        String string3 = "%G";
        Former former = new FormerFactory().create(string3);
        String string4 = System.getProperty("line.separator");
        int[] nArray = floatIHistogram2D.minMaxBins();
        String string5 = floatIHistogram2D.title() + ":" + string4 + "   Entries=" + this.form(former, floatIHistogram2D.entries()) + ", ExtraEntries=" + this.form(former, floatIHistogram2D.extraEntries()) + string4 + "   MeanX=" + this.form(former, floatIHistogram2D.meanX()) + ", RmsX=" + this.form(former, floatIHistogram2D.rmsX()) + string4 + "   MeanY=" + this.form(former, floatIHistogram2D.meanY()) + ", RmsY=" + this.form(former, floatIHistogram2D.rmsX()) + string4 + "   MinBinHeight=" + this.form(former, floatIHistogram2D.binHeight(nArray[0], nArray[1])) + ", MaxBinHeight=" + this.form(former, floatIHistogram2D.binHeight(nArray[2], nArray[3])) + string4 + "   xAxis: " + "Bins=" + this.form(former, floatIHistogram2D.xAxis().bins()) + ", Min=" + this.form(former, floatIHistogram2D.xAxis().lowerEdge()) + ", Max=" + this.form(former, floatIHistogram2D.xAxis().upperEdge()) + string4 + "   yAxis: " + "Bins=" + this.form(former, floatIHistogram2D.yAxis().bins()) + ", Min=" + this.form(former, floatIHistogram2D.yAxis().lowerEdge()) + ", Max=" + this.form(former, floatIHistogram2D.yAxis().upperEdge());
        String[] stringArray = new String[floatIHistogram2D.xAxis().bins()];
        for (int i = 0; i < floatIHistogram2D.xAxis().bins(); ++i) {
            stringArray[i] = this.form(former, floatIHistogram2D.xAxis().binLowerEdge(i));
        }
        Object[] objectArray = new String[floatIHistogram2D.yAxis().bins()];
        for (int i = 0; i < floatIHistogram2D.yAxis().bins(); ++i) {
            objectArray[i] = this.form(former, floatIHistogram2D.yAxis().binLowerEdge(i));
        }
        new ObjectArrayList(objectArray).reverse();
        FloatMatrix2D floatMatrix2D = new DenseFloatMatrix2D(this.toArrayHeights(floatIHistogram2D));
        floatMatrix2D = floatMatrix2D.viewDice().viewRowFlip();
        return string5 + string4 + "Heights:" + string4 + new FloatFormatter().toTitleString(floatMatrix2D, (String[])objectArray, stringArray, string2, string, null, floatBinFunction1DArray);
    }

    public String toString(FloatIHistogram3D floatIHistogram3D) {
        String string = "X";
        String string2 = "Y";
        String string3 = "Z";
        FloatBinFunction1D[] floatBinFunction1DArray = new FloatBinFunction1D[]{FloatBinFunctions1D.sum};
        String string4 = "%G";
        Former former = new FormerFactory().create(string4);
        String string5 = System.getProperty("line.separator");
        int[] nArray = floatIHistogram3D.minMaxBins();
        String string6 = floatIHistogram3D.title() + ":" + string5 + "   Entries=" + this.form(former, floatIHistogram3D.entries()) + ", ExtraEntries=" + this.form(former, floatIHistogram3D.extraEntries()) + string5 + "   MeanX=" + this.form(former, floatIHistogram3D.meanX()) + ", RmsX=" + this.form(former, floatIHistogram3D.rmsX()) + string5 + "   MeanY=" + this.form(former, floatIHistogram3D.meanY()) + ", RmsY=" + this.form(former, floatIHistogram3D.rmsX()) + string5 + "   MeanZ=" + this.form(former, floatIHistogram3D.meanZ()) + ", RmsZ=" + this.form(former, floatIHistogram3D.rmsZ()) + string5 + "   MinBinHeight=" + this.form(former, floatIHistogram3D.binHeight(nArray[0], nArray[1], nArray[2])) + ", MaxBinHeight=" + this.form(former, floatIHistogram3D.binHeight(nArray[3], nArray[4], nArray[5])) + string5 + "   xAxis: " + "Bins=" + this.form(former, floatIHistogram3D.xAxis().bins()) + ", Min=" + this.form(former, floatIHistogram3D.xAxis().lowerEdge()) + ", Max=" + this.form(former, floatIHistogram3D.xAxis().upperEdge()) + string5 + "   yAxis: " + "Bins=" + this.form(former, floatIHistogram3D.yAxis().bins()) + ", Min=" + this.form(former, floatIHistogram3D.yAxis().lowerEdge()) + ", Max=" + this.form(former, floatIHistogram3D.yAxis().upperEdge()) + string5 + "   zAxis: " + "Bins=" + this.form(former, floatIHistogram3D.zAxis().bins()) + ", Min=" + this.form(former, floatIHistogram3D.zAxis().lowerEdge()) + ", Max=" + this.form(former, floatIHistogram3D.zAxis().upperEdge());
        String[] stringArray = new String[floatIHistogram3D.xAxis().bins()];
        for (int i = 0; i < floatIHistogram3D.xAxis().bins(); ++i) {
            stringArray[i] = this.form(former, floatIHistogram3D.xAxis().binLowerEdge(i));
        }
        Object[] objectArray = new String[floatIHistogram3D.yAxis().bins()];
        for (int i = 0; i < floatIHistogram3D.yAxis().bins(); ++i) {
            objectArray[i] = this.form(former, floatIHistogram3D.yAxis().binLowerEdge(i));
        }
        new ObjectArrayList(objectArray).reverse();
        Object[] objectArray2 = new String[floatIHistogram3D.zAxis().bins()];
        for (int i = 0; i < floatIHistogram3D.zAxis().bins(); ++i) {
            objectArray2[i] = this.form(former, floatIHistogram3D.zAxis().binLowerEdge(i));
        }
        new ObjectArrayList(objectArray2).reverse();
        FloatMatrix3D floatMatrix3D = new DenseFloatMatrix3D(this.toArrayHeights(floatIHistogram3D));
        floatMatrix3D = floatMatrix3D.viewDice(2, 1, 0).viewSliceFlip().viewRowFlip();
        return string6 + string5 + "Heights:" + string5 + new FloatFormatter().toTitleString(floatMatrix3D, (String[])objectArray2, (String[])objectArray, stringArray, string3, string2, string, "", floatBinFunction1DArray);
    }

    public String toXML(FloatIHistogram1D floatIHistogram1D) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
        stringBuffer.append(string);
        stringBuffer.append("<!DOCTYPE plotML SYSTEM \"plotML.dtd\">");
        stringBuffer.append(string);
        stringBuffer.append("<plotML>");
        stringBuffer.append(string);
        stringBuffer.append("<plot>");
        stringBuffer.append(string);
        stringBuffer.append("<dataArea>");
        stringBuffer.append(string);
        stringBuffer.append("<data1d>");
        stringBuffer.append(string);
        stringBuffer.append("<bins1d title=\"" + floatIHistogram1D.title() + "\">");
        stringBuffer.append(string);
        for (int i = 0; i < floatIHistogram1D.xAxis().bins(); ++i) {
            stringBuffer.append(floatIHistogram1D.binEntries(i) + "," + floatIHistogram1D.binError(i));
            stringBuffer.append(string);
        }
        stringBuffer.append("</bins1d>");
        stringBuffer.append(string);
        stringBuffer.append("<binnedDataAxisAttributes type=\"float\" axis=\"x0\"");
        stringBuffer.append(" min=\"" + floatIHistogram1D.xAxis().lowerEdge() + "\"");
        stringBuffer.append(" max=\"" + floatIHistogram1D.xAxis().upperEdge() + "\"");
        stringBuffer.append(" numberOfBins=\"" + floatIHistogram1D.xAxis().bins() + "\"");
        stringBuffer.append("/>");
        stringBuffer.append(string);
        stringBuffer.append("<statistics>");
        stringBuffer.append(string);
        stringBuffer.append("<statistic name=\"Entries\" value=\"" + floatIHistogram1D.entries() + "\"/>");
        stringBuffer.append(string);
        stringBuffer.append("<statistic name=\"Underflow\" value=\"" + floatIHistogram1D.binEntries(-2) + "\"/>");
        stringBuffer.append(string);
        stringBuffer.append("<statistic name=\"Overflow\" value=\"" + floatIHistogram1D.binEntries(-1) + "\"/>");
        stringBuffer.append(string);
        if (!Float.isNaN(floatIHistogram1D.mean())) {
            stringBuffer.append("<statistic name=\"Mean\" value=\"" + floatIHistogram1D.mean() + "\"/>");
            stringBuffer.append(string);
        }
        if (!Float.isNaN(floatIHistogram1D.rms())) {
            stringBuffer.append("<statistic name=\"RMS\" value=\"" + floatIHistogram1D.rms() + "\"/>");
            stringBuffer.append(string);
        }
        stringBuffer.append("</statistics>");
        stringBuffer.append(string);
        stringBuffer.append("</data1d>");
        stringBuffer.append(string);
        stringBuffer.append("</dataArea>");
        stringBuffer.append(string);
        stringBuffer.append("</plot>");
        stringBuffer.append(string);
        stringBuffer.append("</plotML>");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public String toXML(FloatIHistogram2D floatIHistogram2D) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
        stringBuffer.append(string);
        stringBuffer.append("<!DOCTYPE plotML SYSTEM \"plotML.dtd\">");
        stringBuffer.append(string);
        stringBuffer.append("<plotML>");
        stringBuffer.append(string);
        stringBuffer.append("<plot>");
        stringBuffer.append(string);
        stringBuffer.append("<dataArea>");
        stringBuffer.append(string);
        stringBuffer.append("<data2d type=\"xxx\">");
        stringBuffer.append(string);
        stringBuffer.append("<bins2d title=\"" + floatIHistogram2D.title() + "\" xSize=\"" + floatIHistogram2D.xAxis().bins() + "\" ySize=\"" + floatIHistogram2D.yAxis().bins() + "\">");
        stringBuffer.append(string);
        for (int i = 0; i < floatIHistogram2D.xAxis().bins(); ++i) {
            for (int j = 0; j < floatIHistogram2D.yAxis().bins(); ++j) {
                stringBuffer.append(floatIHistogram2D.binEntries(i, j) + "," + floatIHistogram2D.binError(i, j));
                stringBuffer.append(string);
            }
        }
        stringBuffer.append("</bins2d>");
        stringBuffer.append(string);
        stringBuffer.append("<binnedDataAxisAttributes type=\"float\" axis=\"x0\"");
        stringBuffer.append(" min=\"" + floatIHistogram2D.xAxis().lowerEdge() + "\"");
        stringBuffer.append(" max=\"" + floatIHistogram2D.xAxis().upperEdge() + "\"");
        stringBuffer.append(" numberOfBins=\"" + floatIHistogram2D.xAxis().bins() + "\"");
        stringBuffer.append("/>");
        stringBuffer.append(string);
        stringBuffer.append("<binnedDataAxisAttributes type=\"float\" axis=\"y0\"");
        stringBuffer.append(" min=\"" + floatIHistogram2D.yAxis().lowerEdge() + "\"");
        stringBuffer.append(" max=\"" + floatIHistogram2D.yAxis().upperEdge() + "\"");
        stringBuffer.append(" numberOfBins=\"" + floatIHistogram2D.yAxis().bins() + "\"");
        stringBuffer.append("/>");
        stringBuffer.append(string);
        stringBuffer.append("</data2d>");
        stringBuffer.append(string);
        stringBuffer.append("</dataArea>");
        stringBuffer.append(string);
        stringBuffer.append("</plot>");
        stringBuffer.append(string);
        stringBuffer.append("</plotML>");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

