/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.map.tlong.AbstractLongIntMap;
import cern.colt.map.tlong.OpenLongIntHashMap;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.SelectedSparseIntMatrix1D;
import cern.colt.matrix.tint.impl.SparseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix3D;

public class SparseIntMatrix1D
extends IntMatrix1D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongIntMap elements;

    public SparseIntMatrix1D(int[] nArray) {
        this(nArray.length);
        this.assign(nArray);
    }

    public SparseIntMatrix1D(int n) {
        this(n, n / 1000, 0.2, 0.5);
    }

    public SparseIntMatrix1D(int n, int n2, double d, double d2) {
        this.setUp(n);
        this.elements = new OpenLongIntHashMap(n2, d, d2);
    }

    protected SparseIntMatrix1D(int n, AbstractLongIntMap abstractLongIntMap, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = abstractLongIntMap;
        this.isNoView = false;
    }

    public IntMatrix1D assign(int n) {
        if (this.isNoView && n == 0) {
            this.elements.clear();
        } else {
            super.assign(n);
        }
        return this;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public AbstractLongIntMap elements() {
        return this.elements;
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public synchronized int getQuick(int n) {
        return this.elements.get((long)this.zero + (long)n * (long)this.stride);
    }

    public long index(int n) {
        return (long)this.zero + (long)n * (long)this.stride;
    }

    public IntMatrix1D like(int n) {
        return new SparseIntMatrix1D(n);
    }

    public IntMatrix2D like2D(int n, int n2) {
        return new SparseIntMatrix2D(n, n2);
    }

    public IntMatrix2D reshape(int n, int n2) {
        if (n * n2 != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        SparseIntMatrix2D sparseIntMatrix2D = new SparseIntMatrix2D(n, n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n4;
                if ((n4 = this.getQuick(n3++)) == 0) continue;
                ((IntMatrix2D)sparseIntMatrix2D).setQuick(j, i, n4);
            }
        }
        return sparseIntMatrix2D;
    }

    public IntMatrix3D reshape(int n, int n2, int n3) {
        if (n * n2 * n3 != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        SparseIntMatrix3D sparseIntMatrix3D = new SparseIntMatrix3D(n, n2, n3);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    int n5;
                    if ((n5 = this.getQuick(n4++)) == 0) continue;
                    ((IntMatrix3D)sparseIntMatrix3D).setQuick(i, k, j, n5);
                }
            }
        }
        return sparseIntMatrix3D;
    }

    public synchronized void setQuick(int n, int n2) {
        long l = (long)this.zero + (long)n * (long)this.stride;
        if (n2 == 0) {
            this.elements.removeKey(l);
        } else {
            this.elements.put(l, n2);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("1 x ").append(this.size).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.size; ++i) {
            int n = this.getQuick(i);
            if (n == 0) continue;
            stringBuilder.append('(').append(i).append(')').append('\t').append(n).append('\n');
        }
        return stringBuilder.toString();
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    protected boolean haveSharedCellsRaw(IntMatrix1D intMatrix1D) {
        if (intMatrix1D instanceof SelectedSparseIntMatrix1D) {
            SelectedSparseIntMatrix1D selectedSparseIntMatrix1D = (SelectedSparseIntMatrix1D)intMatrix1D;
            return this.elements == selectedSparseIntMatrix1D.elements;
        }
        if (intMatrix1D instanceof SparseIntMatrix1D) {
            SparseIntMatrix1D sparseIntMatrix1D = (SparseIntMatrix1D)intMatrix1D;
            return this.elements == sparseIntMatrix1D.elements;
        }
        return false;
    }

    protected IntMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseIntMatrix1D(this.elements, nArray);
    }
}

