/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.WrapperIntMatrix2D;

class DelegateIntMatrix2D
extends IntMatrix2D {
    private static final long serialVersionUID = 1L;
    protected IntMatrix3D content;
    protected int index;
    protected int axis;

    public DelegateIntMatrix2D(IntMatrix3D intMatrix3D, int n, int n2) {
        switch (n) {
            case 0: {
                if (n2 < 0 || n2 >= intMatrix3D.slices()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(intMatrix3D.rows(), intMatrix3D.columns());
                break;
            }
            case 1: {
                if (n2 < 0 || n2 >= intMatrix3D.rows()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(intMatrix3D.slices(), intMatrix3D.columns());
                break;
            }
            case 2: {
                if (n2 < 0 || n2 >= intMatrix3D.columns()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(intMatrix3D.slices(), intMatrix3D.rows());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.axis = n;
        this.index = n2;
        this.content = intMatrix3D;
    }

    public synchronized int getQuick(int n, int n2) {
        switch (this.axis) {
            case 0: {
                return this.content.getQuick(this.index, n, n2);
            }
            case 1: {
                return this.content.getQuick(n, this.index, n2);
            }
            case 2: {
                return this.content.getQuick(n, n2, this.index);
            }
        }
        throw new IllegalArgumentException();
    }

    public IntMatrix2D like(int n, int n2) {
        return this.content.like2D(n, n2);
    }

    public synchronized void setQuick(int n, int n2, int n3) {
        switch (this.axis) {
            case 0: {
                this.content.setQuick(this.index, n, n2, n3);
                break;
            }
            case 1: {
                this.content.setQuick(n, this.index, n2, n3);
                break;
            }
            case 2: {
                this.content.setQuick(n, n2, this.index, n3);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public IntMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        return new WrapperIntMatrix2D(this).viewColumn(n);
    }

    public Object elements() {
        return this.content.elements();
    }

    protected IntMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        throw new InternalError();
    }

    public IntMatrix1D like1D(int n) {
        throw new InternalError();
    }

    protected IntMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    public IntMatrix1D vectorize() {
        DenseIntMatrix1D denseIntMatrix1D = new DenseIntMatrix1D(this.rows * this.columns);
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                ((IntMatrix1D)denseIntMatrix1D).setQuick(n++, this.getQuick(j, i));
            }
        }
        return denseIntMatrix1D;
    }
}

